/*
 * @(#) PickObjectMouseBehavior.java 16-mei-2004
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;

import nl.tudelft.simulation.dsol.animation.D3.Renderable3D;
import nl.tudelft.simulation.introspection.gui.IntroSpectionDialog;

import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;

/**
 * PickObjectMouseBehavior.java <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class PickObjectMouseBehavior extends PickMouseBehavior
{

	/**
	 * Construct a new behavior
	 * 
	 * @param canvas3D A canvas3D
	 * @param root The root branch group
	 * @param bounds Bounds for this behavior
	 */
	public PickObjectMouseBehavior(final Canvas3D canvas3D,
			final BranchGroup root, final Bounds bounds)
	{
		super(canvas3D, root, bounds);
		this.setSchedulingBounds(bounds);
		this.pickCanvas.setMode(PickTool.BOUNDS);
		root.addChild(this);
	}

	/**
	 * @see com.sun.j3d.utils.picking.behaviors.PickMouseBehavior#updateScene(int,
	 *      int)
	 */
	public void updateScene(final int xpos, final int ypos)
	{
		PickResult pickResult = null;
		// Shape3D shape = null;
		BranchGroup group = null;

		this.pickCanvas.setShapeLocation(xpos, ypos);

		pickResult = this.pickCanvas.pickClosest();
		if (pickResult != null)
		{
			// shape = (Shape3D) pickResult.getNode(PickResult.SHAPE3D);
			group = (BranchGroup) pickResult.getNode(PickResult.BRANCH_GROUP);
			if (group != null)
			{
				new IntroSpectionDialog(((Renderable3D) group).getSource(),
						((Renderable3D) group).getSource().toString());

			}
		}
	}
}