/*
 * @(#)RotateXYMouseBehavior.java 1.5 02/04/01 15:04:09
 * 
 * Copyright (c) 1996-2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: -
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. - Redistribution in binary
 * form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided
 * with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 * 
 * You acknowledge that Software is not designed,licensed or intended for use in
 * the design, construction, operation or maintenance of any nuclear facility.
 */
/*
 * Modified to rotate along two axis: x and y. Copyright (c) 2002-2005 Delft
 * University of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands All
 * rights reserved.
 */
package nl.tudelft.simulation.dsol.gui.animation3D.mouse;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;

/**
 * RotateXYMouseBehavior is a Java3D behavior object that lets users control the
 * rotation of an object via a mouse.
 * <p>
 * To use this utility, first create a transform group that this rotate behavior
 * will operate on. Then, <blockquote>
 * 
 * <pre>
 * 
 * 
 * 
 * 
 * 
 * 
 * RotateXYMouseBehavior behavior = new RotateXYMouseBehavior();
 * behavior.setTransformGroup(objTrans);
 * objTrans.addChild(behavior);
 * behavior.setSchedulingBounds(bounds);
 * 
 * 
 * 
 * 
 * 
 * 
 * </pre>
 * 
 * </blockquote> The above code will add the rotate behavior to the transform
 * group. The user can rotate any object attached to the objTrans.
 */

public class RotateXYMouseBehavior extends MouseBehavior
{
	/** y angle */
	private double yAngle;

	/** y factor */
	private double yFactor;

	/** x angle */
	private double xAngle;

	/** x factor */
	private double xFactor;

	/** a second transform group to rotate along the x-axis */
	private TransformGroup transformGroupX = null;

	/**
	 * Creates a rotate behavior given the transform group.
	 * 
	 * @param transformGroup The transformGroup to operate on.
	 */
	public RotateXYMouseBehavior(final TransformGroup transformGroup)
	{
		super(transformGroup);
	}

	/**
	 * Creates a default mouse rotate behavior.
	 */
	public RotateXYMouseBehavior()
	{
		super(0);
	}

	/**
	 * Creates a rotate behavior. Note that this behavior still needs a
	 * transform group to work on (use setTransformGroup(tg)) and the transform
	 * group must add this behavior.
	 * 
	 * @param flags interesting flags (wakeup conditions).
	 */
	public RotateXYMouseBehavior(final int flags)
	{
		super(flags);
	}

	/**
	 * @see javax.media.j3d.Behavior#initialize()
	 */
	public void initialize()
	{
		super.initialize();
		this.yAngle = 0;
		this.yFactor = .03;
		this.xAngle = 0;
		this.xFactor = .03;
		if ((this.flags & INVERT_INPUT) == INVERT_INPUT)
		{
			this.invert = true;
			this.yFactor *= -1;
			this.xFactor *= -1;
		}
	}

	/**
	 * Get y_factor
	 * 
	 * @return y_factor
	 */
	public double getYFactor()
	{
		return this.yFactor;
	}

	/**
	 * Set factor
	 * 
	 * @param factor the factor
	 */
	public void setFactor(final double factor)
	{
		this.yFactor = factor;
		this.xFactor = factor;
	}

	/**
	 * Get x_factor
	 * 
	 * @return x_factor
	 */
	public double getXFactor()
	{
		return this.xFactor;
	}

	/**
	 * @see javax.media.j3d.Behavior#processStimulus(java.util.Enumeration)
	 */
	public void processStimulus(final Enumeration criteria)
	{
		WakeupCriterion wakeup;
		AWTEvent[] event;
		int id;
		int dx;
		int dy;

		while (criteria.hasMoreElements())
		{
			wakeup = (WakeupCriterion) criteria.nextElement();
			if (wakeup instanceof WakeupOnAWTEvent)
			{
				event = ((WakeupOnAWTEvent) wakeup).getAWTEvent();
				for (int i = 0; i < event.length; i++)
				{
					processMouseEvent((MouseEvent) event[i]);

					if (((this.buttonPress) && ((this.flags & MANUAL_WAKEUP) == 0))
							|| ((this.wakeUp) && ((this.flags & MANUAL_WAKEUP) != 0)))
					{

						id = event[i].getID();
						if ((id == MouseEvent.MOUSE_DRAGGED)
								&& !((MouseEvent) event[i]).isMetaDown()
								&& !((MouseEvent) event[i]).isAltDown())
						{

							this.x = ((MouseEvent) event[i]).getX();
							this.y = ((MouseEvent) event[i]).getY();

							dx = this.x - this.x_last;
							dy = this.y - this.y_last;

							if (!this.reset)
							{
								this.yAngle = dx * this.yFactor;
								this.xAngle = dy * this.xFactor;

								// ROTATE ALONG Y AXIS
								this.transformY.rotY(this.yAngle);
								this.transformX.rotX(0.0d);

								this.transformGroup
										.getTransform(this.currXform);

								// Vector3d translation = new Vector3d();
								// Matrix3f rotation = new Matrix3f();
								Matrix4d mat = new Matrix4d();

								// Remember old matrix
								this.currXform.get(mat);

								// Translate to origin
								this.currXform.setTranslation(new Vector3d(0.0,
										0.0, 0.0));
								if (this.invert)
								{
									this.currXform.mul(this.currXform,
											this.transformX);
									this.currXform.mul(this.currXform,
											this.transformY);
								} else
								{
									this.currXform.mul(this.transformX,
											this.currXform);
									this.currXform.mul(this.transformY,
											this.currXform);
								}

								// Set old translation back
								Vector3d translation = new Vector3d(mat.m03,
										mat.m13, mat.m23);
								this.currXform.setTranslation(translation);

								// Update xform
								this.transformGroup
										.setTransform(this.currXform);

								// ROTATE ALONG X AXIS
								this.transformY.rotY(0.0d);
								this.transformX.rotX(this.xAngle);
								this.transformGroupX
										.getTransform(this.currXform);
								this.currXform.get(mat);
								this.currXform.setTranslation(new Vector3d(0.0,
										0.0, 0.0));
								if (this.invert)
								{
									this.currXform.mul(this.currXform,
											this.transformX);
									this.currXform.mul(this.currXform,
											this.transformY);
								} else
								{
									this.currXform.mul(this.transformX,
											this.currXform);
									this.currXform.mul(this.transformY,
											this.currXform);
								}
								translation = new Vector3d(mat.m03, mat.m13,
										mat.m23);
								this.currXform.setTranslation(translation);
								this.transformGroupX
										.setTransform(this.currXform);

							} else
							{
								this.reset = false;
							}

							this.x_last = this.x;
							this.y_last = this.y;
						} else if (id == MouseEvent.MOUSE_PRESSED)
						{
							this.x_last = ((MouseEvent) event[i]).getX();
							this.y_last = ((MouseEvent) event[i]).getY();
						}
					}
				}
			}
		}

		wakeupOn(this.mouseCriterion);

	}

	/**
	 * Get second transform group
	 * 
	 * @return transform group
	 */
	public TransformGroup getTransformGroupX()
	{
		return this.transformGroupX;
	}

	/**
	 * Set second transform group
	 * 
	 * @param group A transformgroup
	 */
	public void setTransformGroupX(final TransformGroup group)
	{
		this.transformGroupX = group;
	}

}