/*
 * @(#) Editor2DFrame.java 20-jul-2004 Copyright (c) 2002-2005 Delft University
 * of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All rights
 * reserved. This software is proprietary information of Delft University of
 * Technology The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

import javax.swing.SwingConstants;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.language.swing.JMultiToolbarFrame;

/**
 * Editor2DFrame.java <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class Editor2DFrame extends JMultiToolbarFrame
{

	/** The application */
	private DSOLApplicationInterface application = null;

	/** Navigation toolbar */
	private NavigationToolbar navigationToolbar = null;

	/** Editor toolbar */
	private EditorToolbar editorToolbar = null;

	/** The editable animation editor2DPanel */
	private Editor2DPanel editor2DPanel = null;

	/**
	 * Constructs a new frame
	 * 
	 * @param application The application
	 */
	public Editor2DFrame(final DSOLApplicationInterface application)
	{
		super();
		this.application = application;

		// Initialize the frame
		this.initialize();
	}

	/**
	 * Initialize the frame
	 */
	private void initialize()
	{
		this.setSize(640, 480);
		this.setTitle("Animation Editor 2D");

		Container pane = this.getContentPane();
		pane.setLayout(new BorderLayout());

		// Initialize animation editor2DPanel

		Rectangle2D extent = null;
		String extentString = this.application.getProperties().getProperty(
				"dsol-gui.animation.panel.extent");
		if (extentString != null)
		{
			double[] values = new double[4];
			for (int i = 0; i < 3; i++)
			{
				values[i] = new Double(extentString.substring(0, extentString
						.indexOf(";"))).doubleValue();
				extentString = extentString
						.substring(extentString.indexOf(";") + 1);
			}
			values[3] = new Double(extentString).doubleValue();
			extent = new Rectangle2D.Double(values[0], values[1], values[2],
					values[3]);
		} else
		{
			extent = new Rectangle2D.Double(-100, -100, 200, 200);
		}
		String sizeString = this.application.getProperties().getProperty(
				"dsol-gui.animation.panel.size");
		Dimension size = new Dimension(600, 600);
		if (sizeString != null)
		{
			double width = new Double(sizeString.substring(0, sizeString
					.indexOf(";"))).doubleValue();
			double height = new Double(sizeString.substring(sizeString
					.indexOf(";") + 1)).doubleValue();
			size = new Dimension((int) width, (int) height);
		}

		this.editor2DPanel = this.createAnimationPanel();
		// Set the editor mode to select
		this.editor2DPanel.setSelectedMode(Editor2DPanel.MODE_SELECT);
		this.editor2DPanel.getExtent().setRect(extent);
		this.editor2DPanel.setSize(size);
		this.editor2DPanel.setFocusable(true);
		this.editor2DPanel.setFocusCycleRoot(true);
		this.editor2DPanel.setFocusTraversalKeysEnabled(true);

		// Create menubar
		MenuBar menuBar = new MenuBar(this, this.application);
		this.setJMenuBar(menuBar);

		// Create panels;
		// pane.add(new
		// NavigationToolbar(editor2DPanel),BorderLayout.NORTH);
		// pane.add(new EditorToolbar(),BorderLayout.WEST);
		this.navigationToolbar = new NavigationToolbar(this.editor2DPanel);
		this.addJToolBar(this.navigationToolbar, SwingConstants.TOP);
		this.editorToolbar = new EditorToolbar(this.application,
				this.editor2DPanel);
		this.addJToolBar(this.editorToolbar, SwingConstants.LEFT);
		pane.add(this.editor2DPanel, BorderLayout.CENTER);

		// What to do to exit
		addWindowListener(new java.awt.event.WindowAdapter()
		{

			public void windowClosing(final java.awt.event.WindowEvent evt)
			{
				Editor2DFrame.this.closeFrame();
			}
		});

		this.pack();
		this.setVisible(true);
	}

	/**
	 * Create the animation panel
	 * 
	 * @return a panel
	 */
	private Editor2DPanel createAnimationPanel()
	{
		Rectangle2D extent = null;
		String extentString = this.application.getProperties().getProperty(
				"dsol-gui.animation.editor2DPanel.extent");
		if (extentString != null)
		{
			double[] values = new double[4];
			for (int i = 0; i < 3; i++)
			{
				values[i] = new Double(extentString.substring(0, extentString
						.indexOf(";"))).doubleValue();
				extentString = extentString
						.substring(extentString.indexOf(";") + 1);
			}
			values[3] = new Double(extentString).doubleValue();
			extent = new Rectangle2D.Double(values[0], values[1], values[2],
					values[3]);
		} else
		{
			extent = new Rectangle2D.Double(-100, -100, 200, 200);
		}
		String sizeString = this.application.getProperties().getProperty(
				"dsol-gui.animation.editor2DPanel.size");
		Dimension size = new Dimension(600, 600);
		if (sizeString != null)
		{
			double width = new Double(sizeString.substring(0, sizeString
					.indexOf(";"))).doubleValue();
			double height = new Double(sizeString.substring(sizeString
					.indexOf(";") + 1)).doubleValue();
			size = new Dimension((int) width, (int) height);
		}
		Editor2DPanel panel = new Editor2DPanel(extent, size, this.application);
		return panel;
	}

	/**
	 * Close this frame
	 */
	protected void closeFrame()
	{
		this.setVisible(false);
	}

	/**
	 * @return Returns the editorToolbar.
	 */
	public EditorToolbar getEditorToolbar()
	{
		return this.editorToolbar;
	}

	/**
	 * @return Returns the navigationTooolbar.
	 */
	public NavigationToolbar getNavigationToolbar()
	{
		return this.navigationToolbar;
	}

	/**
	 * @return Returns the editor2DPanel.
	 */
	public Editor2DPanel getEditableAnimationPanel()
	{
		return this.editor2DPanel;
	}
}