/*
 * @(#) EditorToolbar.java 20-jul-2004 Copyright (c) 2002-2005 Delft University
 * of Technology Jaffalaan 5, 2628 BX Delft, the Netherlands. All rights
 * reserved. This software is proprietary information of Delft University of
 * Technology The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorToolbarActions;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;

/**
 * EditorToolbar.java <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class EditorToolbar extends JToolBar implements EventListenerInterface
{

	/** The application */
	private DSOLApplicationInterface application = null;

	/** Select button */
	private JToggleButton selectObject = null;

	/** New button */
	private JToggleButton newObject = null;

	/** Edit button */
	private JToggleButton editObject = null;

	/** Delete button */
	private JToggleButton deleteObject = null;

	/**
	 * Popup menu with items that can be created by pressing the new-button.
	 */
	private JPopupMenu items = null;

	/** Actions */
	private EditorToolbarActions actions = null;

	/**
	 * Constructor
	 * 
	 * @param application The application
	 * @param panel The panel
	 */
	public EditorToolbar(final DSOLApplicationInterface application,
			final Editor2DPanel panel)
	{
		super();
		this.application = application;
		// Listen to the experiment changed event to be
		// able to update the popup
		try
		{
			this.application.addListener(this,
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
		} catch (RemoteException exception)
		{
			Logger.warning(this, "EditorToolbar", exception);
		}

		this.setFloatable(true);
		this.setOrientation(SwingConstants.VERTICAL);
		this.setRollover(true);

		// Initialize actions
		this.actions = new EditorToolbarActions(this, panel);

		// Buttons
		this.selectObject = createButton("", "Select an object",
				"/editorToolbarButtons/select.gif");
		this.newObject = createButton("", "Create a new object",
				"/editorToolbarButtons/new.gif");
		this.editObject = createButton("", "Edit the selected object",
				"/editorToolbarButtons/edit.gif");
		this.deleteObject = createButton("", "Delete the selected object",
				"/editorToolbarButtons/delete.gif");

		// Popup menu
		this.items = createMenu();
	}

	/**
	 * Create a toolbar button
	 * 
	 * @param text Text on the button
	 * @param tooltip Tooltip text
	 * @param icon Location of icon
	 * @return Button
	 */
	private JToggleButton createButton(final String text, final String tooltip,
			final String icon)
	{
		JToggleButton button = new JToggleButton(text);
		if (!icon.equals(""))
		{
			button.setIcon(new ImageIcon(URLResource.getResource(icon)));
		}
		button.setToolTipText(tooltip);
		button.addActionListener(this.actions);
		this.add(button);
		return button;
	}

	/**
	 * Create a combobox with items to create
	 * 
	 * @return JComboBox
	 */
	private JPopupMenu createMenu()
	{
		JPopupMenu popup = new JPopupMenu();

		JMenuItem menuItem = null;
		popup.removeAll();

		// Fill the popup
		try
		{
			Map editables = Editable.listEditables();
			Set keys = editables.keySet();
			// Loop over the keys to find the classes in the Map.
			for (Iterator i = keys.iterator(); i.hasNext();)
			{
				Object key = i.next();

				menuItem = new JMenuItem(key.toString());
				menuItem.addActionListener(this.actions);
				popup.add(menuItem);
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}

		return popup;
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface#notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		// Recreate the popup menu
		this.items = this.createMenu();
	}

	/**
	 * @return Returns the deleteObject.
	 */
	public JToggleButton getDeleteObject()
	{
		return this.deleteObject;
	}

	/**
	 * @return Returns the editObject.
	 */
	public JToggleButton getEditObject()
	{
		return this.editObject;
	}

	/**
	 * @return Returns the newObject.
	 */
	public JToggleButton getNewObject()
	{
		return this.newObject;
	}

	/**
	 * @return Returns the selectObject.
	 */
	public JToggleButton getSelectObject()
	{
		return this.selectObject;
	}

	/**
	 * @return Returns the items.
	 */
	public JPopupMenu getItems()
	{
		return this.items;
	}
}