/*
 * @(#) MenuBar.java 20-jul-2004
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.MenuBarActions;

/**
 * MenuBar.java <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class MenuBar extends JMenuBar
{

	/** Parent frame */
	private Editor2DFrame source = null;

	/** The application */
	private DSOLApplicationInterface application = null;

	/** save editables */
	private JMenuItem saveEditablesItem = null;

	/** Exit this frame */
	private JMenuItem exitItem = null;

	/** Navigation toolbar menu item */
	private JCheckBoxMenuItem navigationItem = null;

	/** Editor toolbar menu item */
	private JCheckBoxMenuItem editorItem = null;

	/** Actions */
	private MenuBarActions actions = null;

	/**
	 * Constructor
	 * 
	 * @param source Parent frame
	 * @param application The application
	 */
	public MenuBar(final Editor2DFrame source,
			final DSOLApplicationInterface application)
	{
		super();
		this.source = source;
		this.application = application;
		this.initialize();
	}

	/**
	 * Initialize menubar
	 */
	private void initialize()
	{
		// Initialize actions
		this.actions = new MenuBarActions(this, this.application);

		// File menu
		JMenu fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
		// Save
		this.saveEditablesItem = new JMenuItem("Save editables", KeyEvent.VK_S);
		this.saveEditablesItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_S, ActionEvent.ALT_MASK));
		this.saveEditablesItem.getAccessibleContext().setAccessibleDescription(
				"Save editables");
		this.saveEditablesItem.addActionListener(this.actions);
		fileMenu.add(this.saveEditablesItem);
		fileMenu.add(new JSeparator());
		// Exit
		this.exitItem = new JMenuItem("Exit", KeyEvent.VK_X);
		this.exitItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4,
				ActionEvent.ALT_MASK));
		this.exitItem.getAccessibleContext().setAccessibleDescription(
				"Exit this frame");
		this.exitItem.addActionListener(this.actions);
		fileMenu.add(this.exitItem);
		this.add(fileMenu);

		// Add the edit menu from the editable animation panel
		this.add(this.source.getEditableAnimationPanel().getEditMenu());

		// Toolbar menu
		JMenu toolbarMenu = new JMenu("Toolbars");
		toolbarMenu.setMnemonic(KeyEvent.VK_T);

		this.navigationItem = new JCheckBoxMenuItem("Navigation");
		this.navigationItem.setMnemonic(KeyEvent.VK_N);
		this.navigationItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_F4, ActionEvent.ALT_MASK));
		this.navigationItem.getAccessibleContext().setAccessibleDescription(
				"Show navigation toolbar");
		this.navigationItem.addActionListener(this.actions);
		this.navigationItem.setState(true);
		toolbarMenu.add(this.navigationItem);
		toolbarMenu.setVisible(false); // FALSE BECAUSE IT DOES NOT WORK YET!

		this.add(toolbarMenu);
	}

	/**
	 * @return Returns the exitItem.
	 */
	public JMenuItem getExitItem()
	{
		return this.exitItem;
	}

	/**
	 * @return Returns the source.
	 */
	public Editor2DFrame getParentFrame()
	{
		return this.source;
	}

	/**
	 * @return Returns the editorItem.
	 */
	public JCheckBoxMenuItem getEditorItem()
	{
		return this.editorItem;
	}

	/**
	 * @return Returns the navigationItem.
	 */
	public JCheckBoxMenuItem getNavigationItem()
	{
		return this.navigationItem;
	}

	/**
	 * @return Returns the saveEditablesItem.
	 */
	public JMenuItem getSaveEditablesItem()
	{
		return this.saveEditablesItem;
	}

	/**
	 * @return Returns the source.
	 */
	public Editor2DFrame getSource()
	{
		return this.source;
	}
}