/*
 * @(#) OpenURLAction.java Oct 23, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.rmi.RemoteException;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.xml.dsol.ExperimentParsingThread;

/**
 * @author peter
 */
public class OpenRecentAction extends AbstractAction implements
		EventListenerInterface
{

	/** the parent */
	private DSOLApplicationInterface application = null;

	/** the url */
	private String url = null;

	/**
	 * constructs a new OpenURLAction
	 * 
	 * @param application the parent application
	 * @param url the recent url
	 */
	public OpenRecentAction(final DSOLApplicationInterface application,
			final String url)
	{
		super(url);
		this.url = url;
		this.application = application;
		this.setEnabled(false);
		try
		{
			this.application.addListener(this,
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
			this.notify(new Event(
					DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT,
					this.application, this.application.getExperiment()));
		} catch (RemoteException exception)
		{
			Logger.warning(this, "OpenRecentAction", exception);
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		if (event.getSource().equals(this.application)
				&& event.getType().equals(
						DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT))
		{
			if (event.getContent() == null)
			{
				this.setEnabled(true);
			} else
			{
				this.setEnabled(false);
			}
		}
		if (event.getType().equals(
				ExperimentParsingThread.EXPERIMENT_PARSED_EVENT))
		{
			this.application.setExperiment((Experiment) event.getContent());
		}
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	public void finalize() throws Throwable
	{
		this.application.removeListener(this,
				DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
		super.finalize();
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent event)
	{
		try
		{
			new GUIExperimentParsingThread(this, null, new URL(this.url))
					.start();
		} catch (Exception exception)
		{
			JOptionPane.showMessageDialog(null,
					exception.getClass().getName()
							.substring(
									exception.getClass().getName().lastIndexOf(
											".") + 1)
							+ " occurred while connecting " + this.url + ".\n",
					"Error", JOptionPane.ERROR_MESSAGE);
		}
	}
}