/*
 * @(#) RecentAction.java Nov 17, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;

/**
 * The histogram specifies a histogram chart for the DSOL framework.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl/dsol/">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl/dsol/">
 * www.simulation.tudelft.nl/dsol </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm"> Peter
 *         Jacobs </a>
 * @version $Revision$ $Date$
 * @since 1.2
 */
public class RecentAction extends JMenu
{
	/**
	 * constructs a new RecentAction
	 * 
	 * @param application the application
	 */
	public RecentAction(final DSOLApplicationInterface application)
	{
		super("Open Recent");
		for (int i = 0; i < 3; i++)
		{
			String label = application.getProperties().getProperty(
					"recent[" + i + "]");
			if (label != null && label.length() > 0)
			{
				JMenuItem recentItem = new JMenuItem(new OpenRecentAction(
						application, label.split("!#!")[0]));
				this.add(recentItem);
			}
		}
	}
}
