package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation3D.Animation3DFrame;
import nl.tudelft.simulation.logger.Logger;

/**
 * @author roy chin
 * 
 * ir. R.T.H. Chin sk.tbm.tudelft.nl
 */
public class ViewAnimation3dAction extends AbstractAction
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new ViewContextAction
	 * 
	 * @param application the application
	 */
	public ViewAnimation3dAction(final DSOLApplicationInterface application)
	{
		super("3D animation");
		this.application = application;
		this.putValue(Action.MNEMONIC_KEY, new Integer('3'));
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(
				KeyEvent.VK_F5, 0));
		this.setEnabled(true);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed
	 *      (java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent arg0)
	{
		try
		{
			boolean running = false;
			try
			{
				if (this.application.getExperiment().getSimulator().isRunning())
				{
					running = true;
					this.application.getExperiment().getSimulator().stop();
				}
			} catch (NullPointerException nullPointerException)
			{
				// This was meant to happen
				nullPointerException = null;
			}
			Animation3DFrame.initialize(ViewAnimation3dAction.this.application);
			if (running)
			{
				this.application.getExperiment().getSimulator().start();
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}
}