/*
 * @(#) ViewContextAction.java Oct 23, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.windows.ContextFrame;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;

/**
 * The ViewContext action <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class ViewContextAction extends AbstractAction
{
	/** the context */
	private final EventContext context;

	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new ViewContextAction
	 * 
	 * @param application the application
	 * @throws NamingException on failure
	 */
	public ViewContextAction(final DSOLApplicationInterface application)
			throws NamingException
	{
		this(new InitialEventContext(), application);
	}

	/**
	 * constructs a new ViewContextAction
	 * 
	 * @param context the specific context to view
	 * @param application the application
	 */
	public ViewContextAction(final EventContext context,
			final DSOLApplicationInterface application)
	{
		super("Context");
		this.application = application;
		this.putValue(Action.MNEMONIC_KEY, new Integer('C'));
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(
				KeyEvent.VK_F1, 0));
		this.context = context;
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent e)
	{
		try
		{
			boolean running = false;
			try
			{
				if (this.application.getExperiment().getSimulator().isRunning())
				{
					running = true;
					this.application.getExperiment().getSimulator().stop();
				}
			} catch (NullPointerException nullPointerException)
			{
				// This was meant to happen
				nullPointerException = null;
			}
			new ContextFrame(this.context);
			if (running)
			{
				this.application.getExperiment().getSimulator().start();
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}
}