/*
 * @(#) ViewEventlist.java Oct 23, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.menu.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.windows.EventlistFrame;
import nl.tudelft.simulation.logger.Logger;

/**
 * The ViewEventlist action <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class ViewEventlistAction extends AbstractAction
{
	/** application the application */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new ViewContextAction
	 * 
	 * @param application the application
	 */
	public ViewEventlistAction(final DSOLApplicationInterface application)
	{
		super("Eventlist");
		this.application = application;
		this.putValue(Action.MNEMONIC_KEY, new Integer('E'));
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(
				KeyEvent.VK_F4, 0));
		this.setEnabled(true);
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent actionEvent)
	{
		try
		{
			boolean running = false;
			try
			{
				if (this.application.getExperiment().getSimulator().isRunning())
				{
					running = true;
					this.application.getExperiment().getSimulator().stop();
				}
			} catch (NullPointerException nullPointerException)
			{
				// This was meant to happen
				nullPointerException = null;
			}
			new EventlistFrame(this.application);
			if (running)
			{
				this.application.getExperiment().getSimulator().start();
			}
		} catch (Exception exception)
		{
			Logger.warning(this, "actionPerformed", exception);
		}
	}
}