/*
 * @(#) ExperimentTree.java Oct 14, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.panels;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.RunControl;
import nl.tudelft.simulation.dsol.experiment.Treatment;

/**
 * ExperimentTree <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision: 1.4 $ $Date: 2005/01/13 16:28:55 $
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class ExperimentTree extends DefaultTreeModel
{
	/**
	 * constructs a new ExperimentTree
	 * 
	 * @param experiment experiment
	 */
	public ExperimentTree(final Experiment experiment)
	{
		super(new DefaultMutableTreeNode(experiment
				.getProperty(Experiment.EXPERIMENT_NAME)));
		DefaultMutableTreeNode root = (DefaultMutableTreeNode) this.getRoot();
		root.add(new DefaultMutableTreeNode(experiment
				.getProperty(Experiment.EXPERIMENT_ANALYST)));
		root.add(new DefaultMutableTreeNode(experiment.getUrl()));
		for (int i = 0; i < experiment.getTreatments().length; i++)
		{
			root.add(this.getTreatment(experiment.getTreatments()[i]));
		}
	}

	/**
	 * converts a treatment to a treenode
	 * 
	 * @param treatment the treatent
	 * @return DefaultMutableTreeNode
	 */
	private DefaultMutableTreeNode getTreatment(final Treatment treatment)
	{
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Treatment");
		result.add(new DefaultMutableTreeNode("time unit="
				+ treatment.getTimeUnit()));
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(treatment.getStartTime());
		String startTime = calendar.getTime().toString();
		result.add(new DefaultMutableTreeNode("start time=" + startTime));
		result.add(this.getRunControl(treatment.getRunControl()));
		result.add(this.getProperties(treatment.getProperties()));
		return result;
	}

	/**
	 * converts properties to a treeNode
	 * 
	 * @param properties the properties
	 * @return DefaultMutableTreeNode
	 */
	private DefaultMutableTreeNode getProperties(final Properties properties)
	{
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Properties");
		Enumeration keys = properties.keys();
		while (keys.hasMoreElements())
		{
			String key = (String) keys.nextElement();
			String value = properties.getProperty(key);
			result.add(new DefaultMutableTreeNode(key + "(" + value + ")"));
		}
		return result;
	}

	/**
	 * converts a runControl to a treenode
	 * 
	 * @param runControl the runControl
	 * @return DefaultMutableTreeNode
	 */
	private DefaultMutableTreeNode getRunControl(final RunControl runControl)
	{
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("RunControl");
		result.add(new DefaultMutableTreeNode("run length="
				+ runControl.getRunLength()));
		result.add(new DefaultMutableTreeNode("warmup period="
				+ runControl.getWarmupPeriod()));
		for (int i = 0; i < runControl.getReplications().length; i++)
		{
			result.add(this.getReplication(runControl.getReplications()[i]));
		}
		return result;
	}

	/**
	 * converts the replication in a tree node
	 * 
	 * @param replication the replication
	 * @return DefaultMutableTreeNode
	 */
	private DefaultMutableTreeNode getReplication(final Replication replication)
	{
		DefaultMutableTreeNode result = new DefaultMutableTreeNode(
				"Replication");
		result.add(new DefaultMutableTreeNode("description="
				+ replication.getDescription()));
		Map streams = replication.getStreams();
		for (Iterator i = streams.keySet().iterator(); i.hasNext();)
		{
			Object key = i.next();
			result.add(new DefaultMutableTreeNode("stream(" + key + ")="
					+ streams.get(key)));
		}
		return result;
	}
}