/*
 * @(#) AddColumnAction.java Oct 29, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.statistics.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

import nl.tudelft.simulation.dsol.gui.statistics.ChartPanel;
import nl.tudelft.simulation.language.io.URLResource;

/**
 * AddColumnAction <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version 1.1 05.11.2003 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class AddColumnAction extends AbstractAction
{
	/** target of the chartpanel */
	private ChartPanel target = null;

	/**
	 * constructs a new AddColumnAction
	 * 
	 * @param target the target
	 */
	public AddColumnAction(final ChartPanel target)
	{
		super("AddColumn");
		this.target = target;
		this
				.putValue(
						Action.SMALL_ICON,
						new ImageIcon(
								URLResource
										.getResource("/toolbarButtonGraphics/table/ColumnInsertAfter24.gif")));
		this.setEnabled(true);
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent actionEvent)
	{
		new Worker(this.target).start();
	}

	/** SimulatorRunThread extends Thread */
	private class Worker extends Thread
	{
		/** the source */
		private ChartPanel target = null;

		/**
		 * constructs a new
		 * 
		 * @param target the target
		 */
		public Worker(final ChartPanel target)
		{
			this.target = target;
		}

		/**
		 * @see java.lang.Runnable#run()
		 */
		public void run()
		{
			synchronized (this.target)
			{
				this.target.addColumn();
			}
		}
	}
}