/*
 * @(#) ContextFrame.java Oct 26, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.Dimension;

import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.WindowConstants;

import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.context.ContextTreeModel;

/**
 * The ContextFrame <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class ContextFrame extends JFrame
{
	/** the context */
	private EventContext context = null;

	/**
	 * constructs a new ContextFrame
	 * 
	 * @param context the context to see
	 */
	public ContextFrame(final EventContext context)
	{
		super("ContextUtil: " + context);
		this.context = context;
		try
		{
			this.initialize();
		} catch (NamingException namingException)
		{
			Logger.warning(this, "ContextFrame", namingException);
		}
		this.pack();
		this.setVisible(true);
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
	}

	/**
	 * initializes the contextframe
	 * 
	 * @throws NamingException on failure
	 */
	private void initialize() throws NamingException
	{
		this.setContentPane(new JScrollPane(new JTree(new ContextTreeModel(
				this.context, null, true))));
		((JScrollPane) this.getContentPane()).setPreferredSize(new Dimension(
				500, 500));
	}
}