/*
 * @(#) FileChooserFrame.java Oct 13, 2003
 * 
 * Copyright (c) 2002-2005 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands. All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the Lesser General Public License
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.panels.GUIExperimentParsingThread;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * The FileChooserFrame <br>
 * (c) copyright 2002-2005 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/lesser.html">Lesser
 * General Public License (LGPL) </a>, no warranty.
 * 
 * @version $Revision$ $Date$
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class FileChooserFrame extends JFrame implements ActionListener,
		EventListenerInterface
{

	/** source owns the fileChooser */
	private DSOLApplicationInterface application = null;

	/**
	 * constructs a new FileChooserFrame
	 * 
	 * @param application the application
	 * @param directory the default directory
	 */
	public FileChooserFrame(final DSOLApplicationInterface application,
			final String directory)
	{
		super("open experiment");
		this.setLocation(75, 50);
		this.application = application;
		this.initialize(directory);
		this.pack();
		this.setVisible(true);
	}

	/**
	 * initializes the fileChooser
	 * 
	 * @param directory the directory
	 */
	private void initialize(final String directory)
	{
		JFileChooser fileChooser = new JFileChooser(directory);
		fileChooser.addChoosableFileFilter(new FileFilter()
		{

			public boolean accept(final File file)
			{
				if (file.getName().endsWith("xml") || file.isDirectory())
				{
					return true;
				}
				return false;
			}

			public String getDescription()
			{
				return ".xml experiment files";
			}
		});
		fileChooser.addActionListener(this);
		this.getContentPane().add(fileChooser, BorderLayout.CENTER);
	}

	/**
	 * @see java.awt.event.ActionListener
	 *      #actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(final ActionEvent actionEvent)
	{
		if (!actionEvent.getActionCommand().equals("CancelSelection"))
		{
			File selectedFile = ((JFileChooser) actionEvent.getSource())
					.getSelectedFile();
			try
			{
				this.dispose();
				new GUIExperimentParsingThread(this, this, selectedFile.toURL())
						.start();
			} catch (MalformedURLException e)
			{
				Logger.warning(this, "actionPerformed", e);
			}
		} else
		{
			this.dispose();
		}
	}

	/**
	 * @see nl.tudelft.simulation.event.EventListenerInterface
	 *      #notify(nl.tudelft.simulation.event.EventInterface)
	 */
	public void notify(final EventInterface event)
	{
		this.application.setExperiment((Experiment) event.getContent());
	}
}