/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix1DProcedure;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix2D
extends AbstractMatrix2D {
    protected ObjectMatrix2D() {
    }

    public Object aggregate(ObjectObjectFunction objectObjectFunction, ObjectFunction objectFunction) {
        if (this.size() == 0) {
            return null;
        }
        Object object = objectFunction.apply(this.getQuick(this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns - n;
            while (--n3 >= 0) {
                object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(n2, n3)));
            }
            n = 0;
        }
        return object;
    }

    public Object aggregate(ObjectMatrix2D objectMatrix2D, ObjectObjectFunction objectObjectFunction, ObjectObjectFunction objectObjectFunction2) {
        this.checkShape(objectMatrix2D);
        if (this.size() == 0) {
            return null;
        }
        Object object = objectObjectFunction2.apply(this.getQuick(this.rows - 1, this.columns - 1), objectMatrix2D.getQuick(this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns - n;
            while (--n3 >= 0) {
                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(n2, n3), objectMatrix2D.getQuick(n2, n3)));
            }
            n = 0;
        }
        return object;
    }

    public ObjectMatrix2D assign(Object[][] objectArray) {
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
        }
        int n = this.rows;
        while (--n >= 0) {
            Object[] objectArray2 = objectArray[n];
            if (objectArray2.length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + this.columns());
            }
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, objectArray2[n2]);
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectFunction objectFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, objectFunction.apply(this.getQuick(n, n2)));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == this) {
            return this;
        }
        this.checkShape(objectMatrix2D);
        if (this.haveSharedCells(objectMatrix2D)) {
            objectMatrix2D = objectMatrix2D.copy();
        }
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, objectMatrix2D.getQuick(n, n2));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix2D);
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, objectObjectFunction.apply(this.getQuick(n, n2), objectMatrix2D.getQuick(n, n2)));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(Object object) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, object);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns;
            while (--n3 >= 0) {
                if (this.getQuick(n2, n3) == null) continue;
                ++n;
            }
        }
        return n;
    }

    public ObjectMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix2D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix2D objectMatrix2D = (ObjectMatrix2D)object;
        if (this.rows != objectMatrix2D.rows()) {
            return false;
        }
        if (this.columns != objectMatrix2D.columns()) {
            return false;
        }
        if (!bl) {
            int n = this.rows;
            while (--n >= 0) {
                int n2 = this.columns;
                while (--n2 >= 0) {
                    if (this.getQuick(n, n2) == objectMatrix2D.getQuick(n, n2)) continue;
                    return false;
                }
            }
        } else {
            int n = this.rows;
            while (--n >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    if (this.getQuick(n, n3) == null ? objectMatrix2D.getQuick(n, n3) == null : this.getQuick(n, n3).equals(objectMatrix2D.getQuick(n, n3))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Object get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ObjectArrayList objectArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        objectArrayList.clear();
        int n = this.rows;
        int n2 = this.columns;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Object object = this.getQuick(n3, n4);
                if (object != null) {
                    intArrayList.add(n3);
                    intArrayList2.add(n4);
                    objectArrayList.add(object);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public abstract Object getQuick(int var1, int var2);

    protected boolean haveSharedCells(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == null) {
            return false;
        }
        if (this == objectMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        return false;
    }

    public ObjectMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract ObjectMatrix2D like(int var1, int var2);

    public abstract ObjectMatrix1D like1D(int var1);

    protected abstract ObjectMatrix1D like1D(int var1, int var2, int var3);

    public void set(int n, int n2, Object object) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, object);
    }

    public abstract void setQuick(int var1, int var2, Object var3);

    public Object[][] toArray() {
        Object[][] objectArray = new Object[this.rows][this.columns];
        int n = this.rows;
        while (--n >= 0) {
            Object[] objectArray2 = objectArray[n];
            int n2 = this.columns;
            while (--n2 >= 0) {
                objectArray2[n2] = this.getQuick(n, n2);
            }
        }
        return objectArray;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix2D view() {
        return (ObjectMatrix2D)this.clone();
    }

    public ObjectMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public ObjectMatrix2D viewColumnFlip() {
        return (ObjectMatrix2D)this.view().vColumnFlip();
    }

    public ObjectMatrix2D viewDice() {
        return (ObjectMatrix2D)this.view().vDice();
    }

    public ObjectMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (ObjectMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public ObjectMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public ObjectMatrix2D viewRowFlip() {
        return (ObjectMatrix2D)this.view().vRowFlip();
    }

    public ObjectMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray3[n2] = this._rowOffset(this._rowRank(nArray[n2]));
        }
        int n3 = nArray2.length;
        while (--n3 >= 0) {
            nArray4[n3] = this._columnOffset(this._columnRank(nArray2[n3]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public ObjectMatrix2D viewSelection(ObjectMatrix1DProcedure objectMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        int n = 0;
        while (n < this.rows) {
            if (objectMatrix1DProcedure.apply(this.viewRow(n))) {
                intArrayList.add(n);
            }
            ++n;
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    protected abstract ObjectMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public ObjectMatrix2D viewSorted(int n) {
        return Sorting.mergeSort.sort(this, n);
    }

    public ObjectMatrix2D viewStrides(int n, int n2) {
        return (ObjectMatrix2D)this.view().vStrides(n, n2);
    }

    private boolean xforEach(ObjectProcedure objectProcedure) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                if (objectProcedure.apply(this.getQuick(n, n2))) continue;
                return false;
            }
        }
        return true;
    }
}

