/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.d3;

import java.awt.geom.Point2D;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import nl.tudelft.simulation.language.d3.CartesianPoint;
import nl.tudelft.simulation.language.d3.SphericalPoint;

public class DirectedPoint
extends CartesianPoint {
    private double rotX = 0.0;
    private double rotY = 0.0;
    private double rotZ = 0.0;

    public DirectedPoint() {
    }

    public DirectedPoint(double x, double y, double z) {
        super(x, y, z);
    }

    public DirectedPoint(double x, double y, double z, double rotX, double rotY, double rotZ) {
        super(x, y, z);
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
    }

    public DirectedPoint(Point2D point2D, double rotZ) {
        super(point2D);
        this.rotZ = rotZ;
    }

    public DirectedPoint(double[] xyz) {
        super(xyz);
    }

    public DirectedPoint(Point3d cartesianPoint) {
        super(cartesianPoint);
    }

    public DirectedPoint(SphericalPoint sphericalPoint) {
        this(sphericalPoint.toCartesianPoint());
    }

    public DirectedPoint(DirectedPoint location) {
        super(location);
        this.rotY = location.rotY;
        this.rotZ = location.rotZ;
        this.rotX = location.rotX;
    }

    public DirectedPoint(Point2D point2D) {
        super(point2D);
    }

    public DirectedPoint(Point3f point) {
        super(point);
    }

    public DirectedPoint(Tuple3d tuple) {
        super(tuple);
    }

    public DirectedPoint(Tuple3f tuple) {
        super(tuple);
    }

    public double getRotY() {
        return this.rotY;
    }

    public void setRotY(double rotY) {
        this.rotY = rotY;
    }

    public double getRotZ() {
        return this.rotZ;
    }

    public void setRotZ(double rotZ) {
        this.rotZ = rotZ;
    }

    public double getRotX() {
        return this.rotX;
    }

    public void setRotX(double rotX) {
        this.rotX = rotX;
    }

    public String toString() {
        return "[position=" + super.toString() + ";RotX=" + this.rotX + ";RotY=" + this.rotY + ";RotZ=" + this.rotZ + "]";
    }

    public Object clone() {
        return new DirectedPoint(this.x, this.y, this.z, this.rotX, this.rotY, this.rotZ);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof DirectedPoint)) {
            return false;
        }
        DirectedPoint loc = (DirectedPoint)arg0;
        return super.equals(arg0) && loc.rotX == this.rotX && loc.rotY == this.rotY && loc.rotZ == this.rotZ;
    }

    public boolean equals(Tuple3d arg0) {
        return this.equals((Object)arg0);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

