/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;

class ImageComponent3DRetained
extends ImageComponentRetained {
    int depth;

    ImageComponent3DRetained() {
    }

    void setDepth(int n) {
        this.depth = n;
    }

    final int getDepth() {
        return this.depth;
    }

    final void set(int n, BufferedImage bufferedImage) {
        if (this.imageYup == null) {
            this.imageYup = new byte[this.height * this.width * this.depth * this.bytesPerPixelIfStored];
        }
        this.imageDirty[n] = true;
        this.storedYupFormat = this.internalFormat;
        this.bytesPerYupPixelStored = this.bytesPerPixelIfStored;
        this.copyImage(bufferedImage, this.imageYup, true, n, this.storedYupFormat, this.bytesPerYupPixelStored);
        if (this.byReference) {
            this.bImage[n] = bufferedImage;
        }
    }

    final void set(int n, RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            this.set(n, (BufferedImage)renderedImage);
        } else {
            ColorModel colorModel = renderedImage.getColorModel();
            WritableRaster writableRaster = renderedImage.copyData(null);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.set(n, bufferedImage);
        }
    }

    final RenderedImage[] getRenderedImage() {
        int n;
        RenderedImage[] renderedImageArray = new RenderedImage[this.bImage.length];
        if (!this.byReference) {
            n = 0;
            while (n < this.depth) {
                if (this.imageDirty[n]) {
                    this.retrieveBufferedImage(n);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.bImage.length) {
            renderedImageArray[n] = this.bImage[n];
            ++n;
        }
        return renderedImageArray;
    }

    final BufferedImage[] getImage() {
        int n;
        BufferedImage[] bufferedImageArray = new BufferedImage[this.bImage.length];
        if (!this.byReference) {
            n = 0;
            while (n < this.depth) {
                if (this.imageDirty[n]) {
                    this.retrieveBufferedImage(n);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.bImage.length) {
            if (!(this.bImage[n] instanceof BufferedImage)) {
                throw new IllegalStateException(J3dI18N.getString("ImageComponent3DRetained0"));
            }
            bufferedImageArray[n] = (BufferedImage)this.bImage[n];
            ++n;
        }
        return bufferedImageArray;
    }

    final RenderedImage getImage(int n) {
        if (!this.byReference && this.imageDirty[n]) {
            this.retrieveBufferedImage(n);
        }
        return this.bImage[n];
    }

    void updateData(ImageComponent3D.Updater updater, int n, int n2, int n3, int n4, int n5) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent3D)this.source, n, n2, n3, n4, n5);
        if (this.imageYupAllocated) {
            this.copyImage(this.bImage[0], n2 + this.bImage[0].getMinX(), n3 + this.bImage[0].getMinY(), this.imageYup, n2, n3, true, n, n4, n5, this.storedYupFormat, this.bytesPerYupPixelStored);
        }
        this.imageDirty[n] = true;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = VirtualUniverse.mc.getFreeImageUpdateInfo();
            imageComponentUpdateInfo.x = n2;
            imageComponentUpdateInfo.y = n3;
            imageComponentUpdateInfo.z = n;
            imageComponentUpdateInfo.width = n4;
            imageComponentUpdateInfo.height = n5;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }

    void setSubImage(int n, RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.geomLock.getLock();
        if (this.imageYupAllocated) {
            this.copyImage(renderedImage, n4, n5, this.imageYup, n6, n7, true, n, n2, n3, this.storedYupFormat, this.bytesPerYupPixelStored);
        }
        this.imageDirty[n] = true;
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo imageComponentUpdateInfo = VirtualUniverse.mc.getFreeImageUpdateInfo();
            imageComponentUpdateInfo.x = n6;
            imageComponentUpdateInfo.y = n7;
            imageComponentUpdateInfo.z = n;
            imageComponentUpdateInfo.width = n2;
            imageComponentUpdateInfo.height = n3;
            this.sendMessage(2, imageComponentUpdateInfo);
        }
    }
}

