/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.actions;

import java.rmi.RemoteException;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class TimeStepSlider
extends JSlider
implements EventListenerInterface,
ChangeListener {
    private DESSSimulatorInterface simulator;
    private boolean fired = false;

    public TimeStepSlider(DSOLApplicationInterface application) {
        super(0, 700, 100);
        this.setEnabled(false);
        this.addChangeListener(this);
        try {
            application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)application, (Object)application.getExperiment()));
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"TimeStepSlider", (Throwable)exception);
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (this.simulator == null) {
            return;
        }
        if (this.fired) {
            this.fired = false;
            return;
        }
        this.fired = true;
        try {
            boolean shoudPause = this.simulator.isRunning();
            JSlider slider = (JSlider)event.getSource();
            double value = this.getTimeStep(slider.getValue());
            if (shoudPause) {
                this.simulator.stop();
            }
            this.simulator.setTimeStep(0.01 * value);
            if (shoudPause) {
                this.simulator.start();
            }
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"stateChanged", (Throwable)exception);
        }
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals((Object)DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT) && event.getSource() instanceof SimulatorInterface) {
            this.setValue(this.getSliderValue((Double)event.getContent()));
        }
        if (event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT) && event.getSource() instanceof DSOLApplicationInterface) {
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
            }
            return;
        }
        if (event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT) && event.getSource() instanceof Experiment && event.getContent() != null && event.getContent() instanceof DESSSimulatorInterface) {
            this.simulator = (DESSSimulatorInterface)event.getContent();
            this.notify((EventInterface)new Event(DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT, (Object)this.simulator, (Object)new Double(this.simulator.getTimeStep())));
            this.simulator.addListener((EventListenerInterface)this, DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT);
            this.setEnabled(true);
        }
    }

    public int getSliderValue(double timeStep) {
        int sliderValue = (int)(600L + Math.round(100.0 * Math.log(timeStep) / Math.log(10.0)));
        return sliderValue;
    }

    public double getTimeStep(int value) {
        double timeStep = Math.pow(10.0, (double)(value - 600) / 100.0);
        return timeStep;
    }
}

