/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.animation3D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation3D.Animation3DCanvas;
import nl.tudelft.simulation.dsol.gui.panels.Statusbar;

public final class Animation3DFrame
extends JFrame
implements ActionListener {
    private static Animation3DFrame frame = null;
    private DSOLApplicationInterface application = null;
    private Animation3DCanvas animation3DPanel = null;
    private JButton homeButton = new JButton("Home");

    private Animation3DFrame(DSOLApplicationInterface application) {
        this.application = application;
        this.animation3DPanel = new Animation3DCanvas(application);
        this.initializeFrame();
    }

    public static JFrame initialize(DSOLApplicationInterface application) {
        if (frame != null) {
            ((Component)frame).setVisible(true);
        } else {
            frame = new Animation3DFrame(application);
        }
        return frame;
    }

    public void initializeFrame() {
        this.setTitle("Animation3D");
        ((Component)this).setSize(640, 480);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BorderLayout());
        if (this.application != null) {
            Statusbar statusbar = new Statusbar(this.application);
            bottom.add("West", statusbar);
        }
        JPanel east = new JPanel();
        east.setLayout(new FlowLayout());
        east.add("East", this.homeButton);
        bottom.add("East", east);
        this.homeButton.addActionListener(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", (Component)((Object)this.animation3DPanel));
        container.add("South", bottom);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Animation3DFrame.this.closeFrame();
            }
        });
        ((Component)this).setVisible(true);
    }

    protected void closeFrame() {
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.homeButton) {
            this.animation3DPanel.getViewBranch().resetView();
        }
    }
}

