/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.EditorToolbar;
import nl.tudelft.simulation.dsol.gui.editor2D.MenuBar;
import nl.tudelft.simulation.dsol.gui.editor2D.NavigationToolbar;
import nl.tudelft.simulation.language.swing.JMultiToolbarFrame;

public class Editor2DFrame
extends JMultiToolbarFrame {
    private DSOLApplicationInterface application = null;
    private NavigationToolbar navigationToolbar = null;
    private EditorToolbar editorToolbar = null;
    private Editor2DPanel editor2DPanel = null;

    public Editor2DFrame(DSOLApplicationInterface application) {
        this.application = application;
        this.initialize();
    }

    private void initialize() {
        ((Component)((Object)this)).setSize(640, 480);
        ((Frame)((Object)this)).setTitle("Animation Editor 2D");
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        Rectangle2D.Double extent = null;
        String extentString = this.application.getProperties().getProperty("dsol-gui.animation.panel.extent");
        if (extentString != null) {
            double[] values = new double[4];
            for (int i = 0; i < 3; ++i) {
                values[i] = new Double(extentString.substring(0, extentString.indexOf(";")));
                extentString = extentString.substring(extentString.indexOf(";") + 1);
            }
            values[3] = new Double(extentString);
            extent = new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        } else {
            extent = new Rectangle2D.Double(-100.0, -100.0, 200.0, 200.0);
        }
        String sizeString = this.application.getProperties().getProperty("dsol-gui.animation.panel.size");
        Dimension size = new Dimension(600, 600);
        if (sizeString != null) {
            double width = new Double(sizeString.substring(0, sizeString.indexOf(";")));
            double height = new Double(sizeString.substring(sizeString.indexOf(";") + 1));
            size = new Dimension((int)width, (int)height);
        }
        this.editor2DPanel = this.createAnimationPanel();
        this.editor2DPanel.setSelectedMode(1);
        this.editor2DPanel.getExtent().setRect(extent);
        this.editor2DPanel.setSize(size);
        this.editor2DPanel.setFocusable(true);
        this.editor2DPanel.setFocusCycleRoot(true);
        this.editor2DPanel.setFocusTraversalKeysEnabled(true);
        MenuBar menuBar = new MenuBar(this, this.application);
        ((JFrame)((Object)this)).setJMenuBar(menuBar);
        this.navigationToolbar = new NavigationToolbar(this.editor2DPanel);
        this.addJToolBar(this.navigationToolbar, 1);
        this.editorToolbar = new EditorToolbar(this.application, this.editor2DPanel);
        this.addJToolBar(this.editorToolbar, 2);
        pane.add((Component)this.editor2DPanel, "Center");
        ((Window)((Object)this)).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Editor2DFrame.this.closeFrame();
            }
        });
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setVisible(true);
    }

    private Editor2DPanel createAnimationPanel() {
        Rectangle2D.Double extent = null;
        String extentString = this.application.getProperties().getProperty("dsol-gui.animation.editor2DPanel.extent");
        if (extentString != null) {
            double[] values = new double[4];
            for (int i = 0; i < 3; ++i) {
                values[i] = new Double(extentString.substring(0, extentString.indexOf(";")));
                extentString = extentString.substring(extentString.indexOf(";") + 1);
            }
            values[3] = new Double(extentString);
            extent = new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        } else {
            extent = new Rectangle2D.Double(-100.0, -100.0, 200.0, 200.0);
        }
        String sizeString = this.application.getProperties().getProperty("dsol-gui.animation.editor2DPanel.size");
        Dimension size = new Dimension(600, 600);
        if (sizeString != null) {
            double width = new Double(sizeString.substring(0, sizeString.indexOf(";")));
            double height = new Double(sizeString.substring(sizeString.indexOf(";") + 1));
            size = new Dimension((int)width, (int)height);
        }
        Editor2DPanel panel = new Editor2DPanel(extent, size, this.application);
        return panel;
    }

    protected void closeFrame() {
        ((Component)((Object)this)).setVisible(false);
    }

    public EditorToolbar getEditorToolbar() {
        return this.editorToolbar;
    }

    public NavigationToolbar getNavigationToolbar() {
        return this.navigationToolbar;
    }

    public Editor2DPanel getEditableAnimationPanel() {
        return this.editor2DPanel;
    }
}

