/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import javax.naming.event.NamingEvent;
import nl.tudelft.simulation.dsol.animation.D2.EditableRenderable2DInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation2D.AnimationPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.mouse.InputListener;
import nl.tudelft.simulation.dsol.gui.editor2D.EditMenu;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities;
import nl.tudelft.simulation.dsol.gui.editor2D.mouse.EditorInputListener;
import nl.tudelft.simulation.language.d3.CartesianPoint;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public class Editor2DPanel
extends AnimationPanel {
    public static final int MODE_IDLE = 0;
    public static final int MODE_SELECT = 1;
    public static final int MODE_NEW = 2;
    public static final int MODE_EDIT = 3;
    public static final int MODE_DELETE = 4;
    public static final int EDIT_MODE_MOVE = 1;
    public static final int EDIT_MODE_ROTATE = 2;
    public static final int PLACEHOLDERSIZE = 2;
    public static final int LOCALAXISSIZE = 20;
    private EditMenu editMenu = null;
    private int selectedMode = 0;
    private int selectedEditMode = 1;
    private EditableRenderable2DInterface selectedEditableRenderable = null;
    private Class selectedRenderableClass = null;
    private CartesianPoint selectedPoint = null;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$editor2D$Editor2DPanel;

    public Editor2DPanel(Rectangle2D extent, Dimension size, DSOLApplicationInterface application) {
        super(extent, size, application);
        MouseListener[] mouseListeners = this.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            this.removeMouseListener(mouseListeners[i]);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListeners[i]);
        }
        String mouseEditorClassName = application.getProperties().getProperty("dsol-gui.editor2D.panel.editorInputListener");
        if (mouseEditorClassName != null) {
            try {
                Class<?> editorClass = Class.forName(mouseEditorClassName);
                Constructor constructor = ClassUtil.resolveConstructor(editorClass, (Class[])new Class[]{class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface == null ? (class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface = Editor2DPanel.class$("nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface")) : class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface, class$nl$tudelft$simulation$dsol$gui$editor2D$Editor2DPanel == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$Editor2DPanel = Editor2DPanel.class$("nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel")) : class$nl$tudelft$simulation$dsol$gui$editor2D$Editor2DPanel});
                InputListener mouseListener = (InputListener)constructor.newInstance(application, this);
                this.addMouseListener(mouseListener);
                this.addMouseMotionListener(mouseListener);
                this.addMouseWheelListener(mouseListener);
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"<init>", (String)("could not load " + mouseEditorClassName));
                EditorInputListener mouse = new EditorInputListener(application, this);
                this.addMouseListener(mouse);
                this.addMouseMotionListener(mouse);
                this.addMouseWheelListener(mouse);
            }
        } else {
            EditorInputListener mouse = new EditorInputListener(application, this);
            this.addMouseListener(mouse);
            this.addMouseMotionListener(mouse);
            this.addMouseWheelListener(mouse);
        }
        this.editMenu = new EditMenu("Edit", this);
    }

    public void objectAdded(NamingEvent namingEvent) {
        super.objectAdded(namingEvent);
        Renderable2DInterface element = (Renderable2DInterface)namingEvent.getNewBinding().getObject();
        if (element instanceof EditableRenderable2DInterface) {
            this.setSelectedEditableRenderable((EditableRenderable2DInterface)element);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getSelectedEditableRenderable() != null) {
            try {
                int i;
                g.setColor(Color.RED);
                EditableRenderable2DInterface selected = this.getSelectedEditableRenderable();
                Editable editable = (Editable)selected.getSource();
                CartesianPoint[] vertices = editable.getVertices();
                CartesianPoint[] positions = new CartesianPoint[vertices.length];
                for (i = 0; i < positions.length; ++i) {
                    positions[i] = EditorUtilities.convertToGlobalCoordinates(vertices[i], editable.getLocation());
                }
                for (i = 0; i < positions.length - 1; ++i) {
                    Point2D p1 = Renderable2DInterface.Util.getScreenCoordinates((Point2D)new Point2D.Double(positions[i].x, positions[i].y), (Rectangle2D)this.extent, (Dimension)this.getSize());
                    Point2D p2 = Renderable2DInterface.Util.getScreenCoordinates((Point2D)new Point2D.Double(positions[i + 1].x, positions[i + 1].y), (Rectangle2D)this.extent, (Dimension)this.getSize());
                    g.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
                    if (positions[i] == this.getSelectedPoint()) {
                        g.setColor(Color.YELLOW);
                    }
                    g.fillRect((int)p1.getX() - 2, (int)p1.getY() - 2, 5, 5);
                    g.setColor(Color.RED);
                }
                Point2D p1 = Renderable2DInterface.Util.getScreenCoordinates((Point2D)new Point2D.Double(positions[0].x, positions[0].y), (Rectangle2D)this.extent, (Dimension)this.getSize());
                Point2D p2 = Renderable2DInterface.Util.getScreenCoordinates((Point2D)new Point2D.Double(positions[positions.length - 1].x, positions[positions.length - 1].y), (Rectangle2D)this.extent, (Dimension)this.getSize());
                if (selected.isClosedShape()) {
                    g.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
                }
                if (positions[positions.length - 1] == this.getSelectedPoint()) {
                    g.setColor(Color.YELLOW);
                }
                g.fillRect((int)p2.getX() - 2, (int)p2.getY() - 2, 5, 5);
                g.setColor(Color.RED);
                DirectedPoint location = selected.getSource().getLocation();
                Point2D loc = Renderable2DInterface.Util.getScreenCoordinates((Point2D)location.to2D(), (Rectangle2D)this.extent, (Dimension)this.getSize());
                g.drawLine((int)(loc.getX() - 2.0), (int)loc.getY(), (int)(loc.getX() + 2.0), (int)loc.getY());
                g.drawLine((int)loc.getX(), (int)(loc.getY() - 2.0), (int)loc.getX(), (int)(loc.getY() + 2.0));
                g.drawLine((int)loc.getX(), (int)loc.getY(), (int)(loc.getX() + Math.cos(location.getRotZ()) * 20.0), (int)(loc.getY() - Math.sin(location.getRotZ()) * 20.0));
                g.drawLine((int)loc.getX(), (int)loc.getY(), (int)(loc.getX() - Math.sin(location.getRotZ()) * 20.0), (int)(loc.getY() - Math.cos(location.getRotZ()) * 20.0));
                g.drawString("x", (int)(loc.getX() + Math.cos(location.getRotZ()) * 20.0), (int)(loc.getY() - Math.sin(location.getRotZ()) * 20.0));
                g.drawString("y", (int)(loc.getX() - Math.sin(location.getRotZ()) * 20.0), (int)(loc.getY() - Math.cos(location.getRotZ()) * 20.0));
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"paintComponent", (Throwable)exception);
            }
        }
    }

    public EditMenu getEditMenu() {
        return this.editMenu;
    }

    public int getSelectedMode() {
        return this.selectedMode;
    }

    public void setSelectedMode(int mode) {
        this.selectedMode = mode;
    }

    public EditableRenderable2DInterface getSelectedEditableRenderable() {
        return this.selectedEditableRenderable;
    }

    public void setSelectedEditableRenderable(EditableRenderable2DInterface selectedEditableRenderable) {
        this.selectedEditableRenderable = selectedEditableRenderable;
    }

    public Class getSelectedRenderableClass() {
        return this.selectedRenderableClass;
    }

    public void setSelectedRenderableClass(Class selectedRenderableClass) {
        this.selectedRenderableClass = selectedRenderableClass;
    }

    public int getSelectedEditMode() {
        return this.selectedEditMode;
    }

    public void setSelectedEditMode(int selectedEditMode) {
        this.selectedEditMode = selectedEditMode;
    }

    public CartesianPoint getSelectedPoint() {
        return this.selectedPoint;
    }

    public void setSelectedPoint(CartesianPoint selectedPoint) {
        this.selectedPoint = selectedPoint;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

