/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D;

import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorToolbarActions;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;

public class EditorToolbar
extends JToolBar
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;
    private JToggleButton selectObject = null;
    private JToggleButton newObject = null;
    private JToggleButton editObject = null;
    private JToggleButton deleteObject = null;
    private JPopupMenu items = null;
    private EditorToolbarActions actions = null;

    public EditorToolbar(DSOLApplicationInterface application, Editor2DPanel panel) {
        this.application = application;
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"EditorToolbar", (Throwable)exception);
        }
        this.setFloatable(true);
        this.setOrientation(1);
        this.setRollover(true);
        this.actions = new EditorToolbarActions(this, panel);
        this.selectObject = this.createButton("", "Select an object", "/editorToolbarButtons/select.gif");
        this.newObject = this.createButton("", "Create a new object", "/editorToolbarButtons/new.gif");
        this.editObject = this.createButton("", "Edit the selected object", "/editorToolbarButtons/edit.gif");
        this.deleteObject = this.createButton("", "Delete the selected object", "/editorToolbarButtons/delete.gif");
        this.items = this.createMenu();
    }

    private JToggleButton createButton(String text, String tooltip, String icon) {
        JToggleButton button = new JToggleButton(text);
        if (!icon.equals("")) {
            button.setIcon(new ImageIcon(URLResource.getResource((String)icon)));
        }
        button.setToolTipText(tooltip);
        button.addActionListener(this.actions);
        this.add(button);
        return button;
    }

    private JPopupMenu createMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = null;
        popup.removeAll();
        try {
            Map editables = Editable.listEditables();
            Set keys = editables.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                menuItem = new JMenuItem(key.toString());
                menuItem.addActionListener(this.actions);
                popup.add(menuItem);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"actionPerformed", (Throwable)exception);
        }
        return popup;
    }

    public void notify(EventInterface event) {
        this.items = this.createMenu();
    }

    public JToggleButton getDeleteObject() {
        return this.deleteObject;
    }

    public JToggleButton getEditObject() {
        return this.editObject;
    }

    public JToggleButton getNewObject() {
        return this.newObject;
    }

    public JToggleButton getSelectObject() {
        return this.selectObject;
    }

    public JPopupMenu getItems() {
        return this.items;
    }
}

