/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D.actions;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.animation.D2.EditableRenderable2DInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.language.d3.CartesianPoint;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public final class EditorUtilities {
    public static final int DEFAULT_OFFSET = 8;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$simulators$SimulatorInterface;
    static /* synthetic */ Class class$nl$tudelft$simulation$language$d3$DirectedPoint;

    private EditorUtilities() {
    }

    public static Renderable2DInterface selectEditable(Point2D worldCoordinate, Editor2DPanel panel) {
        Renderable2DInterface selected = EditorUtilities.determineSelected(worldCoordinate, panel);
        if (selected == null) {
            panel.setSelectedEditableRenderable(null);
        } else {
            try {
                if (selected instanceof EditableRenderable2DInterface) {
                    panel.setSelectedEditableRenderable((EditableRenderable2DInterface)selected);
                }
            }
            catch (ClassCastException exception) {
                Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"selectEditable", (Throwable)exception);
            }
        }
        return selected;
    }

    public static void instantiateNewEditable(Point2D worldCoordinate, DSOLApplicationInterface application, Editor2DPanel panel) {
        panel.setSelectedEditableRenderable(null);
        Class editableClass = panel.getSelectedRenderableClass();
        try {
            Class[] argsClass = new Class[]{class$nl$tudelft$simulation$dsol$simulators$SimulatorInterface == null ? (class$nl$tudelft$simulation$dsol$simulators$SimulatorInterface = EditorUtilities.class$("nl.tudelft.simulation.dsol.simulators.SimulatorInterface")) : class$nl$tudelft$simulation$dsol$simulators$SimulatorInterface, class$nl$tudelft$simulation$language$d3$DirectedPoint == null ? (class$nl$tudelft$simulation$language$d3$DirectedPoint = EditorUtilities.class$("nl.tudelft.simulation.language.d3.DirectedPoint")) : class$nl$tudelft$simulation$language$d3$DirectedPoint};
            Object[] args = new Object[]{application.getExperiment().getSimulator(), new DirectedPoint(worldCoordinate.getX(), worldCoordinate.getY(), 0.0)};
            Constructor constructor = ClassUtil.resolveConstructor((Class)editableClass, (Class[])argsClass);
            constructor.newInstance(args);
        }
        catch (Exception exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"instantiateNewEditable", (Throwable)exception);
        }
    }

    public static void moveSelectedPoint(EditableRenderable2DInterface target, Point2D worldCoordinate, Editor2DPanel panel) {
        try {
            Editable editable = (Editable)target.getSource();
            CartesianPoint[] vertices = editable.getVertices();
            if (target.allowEditPoints()) {
                CartesianPoint[] newPos = new CartesianPoint[vertices.length];
                for (int i = 0; i < vertices.length; ++i) {
                    newPos[i] = new CartesianPoint();
                    if (vertices[i] == panel.getSelectedPoint()) {
                        CartesianPoint coord = EditorUtilities.convertToLocalCoordinates(new CartesianPoint(worldCoordinate.getX(), worldCoordinate.getY(), 0.0), editable.getLocation());
                        newPos[i].x = coord.x;
                        newPos[i].y = coord.y;
                        newPos[i].z = vertices[i].z;
                        continue;
                    }
                    newPos[i].x = vertices[i].x;
                    newPos[i].y = vertices[i].y;
                    newPos[i].z = vertices[i].z;
                }
                editable.setVertices(newPos);
            }
        }
        catch (RemoteException exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"moveSelectedPoint", (Throwable)exception);
        }
    }

    public static void moveEditable(EditableRenderable2DInterface target, Point2D newCoordinate, Point2D oldCoordinate) {
        try {
            Editable editable = (Editable)target.getSource();
            if (editable != null && target.allowMove()) {
                double dx = newCoordinate.getX() - oldCoordinate.getX();
                double dy = newCoordinate.getY() - oldCoordinate.getY();
                DirectedPoint location = editable.getLocation();
                location.x += dx;
                location.y += dy;
            }
        }
        catch (RemoteException exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"moveEditable", (Throwable)exception);
        }
    }

    public static void rotateEditable(EditableRenderable2DInterface target, Point2D newCoordinate, Point2D centerCoordinate, Point2D oldCoordinate) {
        try {
            Editable editable = (Editable)target.getSource();
            if (editable != null && target.allowRotate()) {
                double dx = newCoordinate.getX() - oldCoordinate.getX();
                double dy = newCoordinate.getY() - oldCoordinate.getY();
                double dxR = oldCoordinate.getX() - centerCoordinate.getX();
                double dyR = oldCoordinate.getY() - centerCoordinate.getY();
                double dxR2 = newCoordinate.getX() - centerCoordinate.getX();
                double dyR2 = newCoordinate.getY() - centerCoordinate.getY();
                double distY = Math.sqrt(dx * dx + dy * dy);
                double distX = Math.sqrt(dxR * dxR + dyR * dyR);
                int factor = 1;
                if (Math.atan2(dyR, dxR) > Math.atan2(dyR2, dxR2)) {
                    factor = -1;
                }
                double angle = (double)factor * Math.atan2(distY, distX);
                DirectedPoint location = editable.getLocation();
                double dxP = location.x - centerCoordinate.getX();
                double dyP = location.y - centerCoordinate.getY();
                double distanceP = Math.sqrt(dxP * dxP + dyP * dyP);
                double angleP = Math.atan2(dyP, dxP);
                location.x = centerCoordinate.getX() + distanceP * Math.cos(angle + angleP);
                location.y = centerCoordinate.getY() + distanceP * Math.sin(angle + angleP);
                location.setRotZ(angle + location.getRotZ());
            }
        }
        catch (RemoteException exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"rotateEditable", (Throwable)exception);
        }
    }

    public static void deleteEditable(EditableRenderable2DInterface target, Editor2DPanel panel) {
        Editable editable = (Editable)target.getSource();
        if (editable != null) {
            try {
                if (target.allowDelete()) {
                    target.destroy();
                    panel.setSelectedEditableRenderable(null);
                    panel.setSelectedPoint(null);
                    panel.repaint();
                }
            }
            catch (RemoteException exception) {
                Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"deleteEditable", (Throwable)exception);
            }
        }
    }

    public static void addPointToEditable(EditableRenderable2DInterface target, Editor2DPanel panel) {
        try {
            double delta = 8.0 * Renderable2DInterface.Util.getScale((Rectangle2D)panel.getExtent(), (Dimension)panel.getSize());
            Editable editable = (Editable)target.getSource();
            CartesianPoint[] vertices = editable.getVertices();
            if (target.allowAddOrDeletePoints() && vertices.length < target.getMaxNumberOfPoints()) {
                CartesianPoint[] newPos = new CartesianPoint[vertices.length + 1];
                for (int i = 0; i < newPos.length; ++i) {
                    newPos[i] = new CartesianPoint();
                    if (i == newPos.length - 1) {
                        newPos[i].x = vertices[i - 1].x + delta;
                        newPos[i].y = vertices[i - 1].y + delta;
                        newPos[i].z = vertices[i - 1].z;
                        continue;
                    }
                    newPos[i].x = vertices[i].x;
                    newPos[i].y = vertices[i].y;
                    newPos[i].z = vertices[i].z;
                }
                editable.setVertices(newPos);
                panel.repaint();
            }
        }
        catch (RemoteException exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"addPointToEditable", (Throwable)exception);
        }
    }

    public static Renderable2DInterface determineSelected(Point2D worldCoordinate, Editor2DPanel panel) {
        Renderable2DInterface selected = null;
        EditableRenderable2DInterface previous = panel.getSelectedEditableRenderable();
        List targets = EditorUtilities.determineTargets(worldCoordinate, panel);
        if (previous != null) {
            int index = -1;
            for (int i = 0; i < targets.size(); ++i) {
                if (previous != (Renderable2DInterface)targets.get(i)) continue;
                index = i;
            }
            if (index >= 0) {
                selected = index + 1 < targets.size() ? (Renderable2DInterface)targets.get(index + 1) : (Renderable2DInterface)targets.get(0);
            } else if (targets.size() > 0) {
                selected = (Renderable2DInterface)targets.get(0);
            }
        } else {
            try {
                double zValue = -1.7976931348623157E308;
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    Renderable2DInterface next = (Renderable2DInterface)i.next();
                    double z = next.getSource().getLocation().z;
                    if (!(z > zValue)) continue;
                    zValue = z;
                    selected = next;
                }
            }
            catch (RemoteException exception) {
                Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"determineSelected", (Throwable)exception);
            }
        }
        return selected;
    }

    public static List determineTargets(Point2D worldCoordinate, Editor2DPanel panel) {
        ArrayList<Renderable2DInterface> targets = new ArrayList<Renderable2DInterface>();
        try {
            Iterator i = panel.getElements().iterator();
            while (i.hasNext()) {
                Renderable2DInterface renderable = (Renderable2DInterface)i.next();
                if (!renderable.contains(worldCoordinate, panel.getExtent(), panel.getSize())) continue;
                targets.add(renderable);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)(class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities == null ? (class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities = EditorUtilities.class$("nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities")) : class$nl$tudelft$simulation$dsol$gui$editor2D$actions$EditorUtilities), (String)"determineTargets", (Throwable)exception);
        }
        return targets;
    }

    public static CartesianPoint convertToGlobalCoordinates(CartesianPoint point, DirectedPoint location) {
        CartesianPoint global = new CartesianPoint();
        double angle = Math.atan2(point.y, point.x);
        double length = Math.sqrt(point.x * point.x + point.y * point.y);
        double rotation = location.getRotZ() + angle;
        global.x = length * Math.cos(rotation);
        global.y = length * Math.sin(rotation);
        global.x += location.x;
        global.y += location.y;
        return global;
    }

    public static CartesianPoint convertToLocalCoordinates(CartesianPoint point, DirectedPoint location) {
        CartesianPoint local = new CartesianPoint();
        local.x = point.x - location.x;
        local.y = point.y - location.y;
        double angle = Math.atan2(local.y, local.x);
        double length = Math.sqrt(local.x * local.x + local.y * local.y);
        double rotation = angle - location.getRotZ();
        local.x = length * Math.cos(rotation);
        local.y = length * Math.sin(rotation);
        return local;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

