/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.editor2D.mouse;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import nl.tudelft.simulation.dsol.animation.D2.EditableRenderable2DInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface;
import nl.tudelft.simulation.dsol.animation.Editable;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.animation2D.AnimationPanel;
import nl.tudelft.simulation.dsol.gui.animation2D.mouse.InputListener;
import nl.tudelft.simulation.dsol.gui.editor2D.Editor2DPanel;
import nl.tudelft.simulation.dsol.gui.editor2D.actions.EditorUtilities;
import nl.tudelft.simulation.introspection.gui.IntroSpectionDialog;
import nl.tudelft.simulation.language.d3.CartesianPoint;

public class EditorInputListener
extends InputListener {
    protected Editor2DPanel panel = null;
    protected boolean clickedWithinSelected = false;
    protected int mouseButton = 0;
    protected Point2D dragCoord = null;

    public EditorInputListener(DSOLApplicationInterface application, AnimationPanel panel) {
        super(application, panel);
        this.panel = (Editor2DPanel)panel;
    }

    public void mouseClicked(MouseEvent event) {
        this.panel.requestFocus();
    }

    public void mouseDragged(MouseEvent event) {
        super.mouseDragged(event);
        Point2D newCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)event.getPoint(), (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        Point2D centerCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)this.mouseClicked, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        Point2D oldCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)this.dragCoord, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        if (this.mouseButton == 1 && this.panel.getSelectedMode() == 3 && this.panel.getSelectedPoint() == null && this.clickedWithinSelected) {
            if (this.panel.getSelectedEditMode() == 1) {
                EditorUtilities.moveEditable(this.panel.getSelectedEditableRenderable(), newCoordinate, oldCoordinate);
            } else if (this.panel.getSelectedEditMode() == 2) {
                EditorUtilities.rotateEditable(this.panel.getSelectedEditableRenderable(), newCoordinate, centerCoordinate, oldCoordinate);
            }
        }
        this.dragCoord = (Point2D)event.getPoint().clone();
    }

    public void mousePressed(MouseEvent event) {
        super.mousePressed(event);
        this.mouseButton = event.getButton();
        this.dragCoord = event.getPoint();
        if (this.panel.getSelectedMode() == 3) {
            CartesianPoint selectedPoint = this.determineSelectedVertice(this.mouseClicked);
            this.panel.setSelectedPoint(selectedPoint);
            if (this.panel.getSelectedPoint() == null) {
                this.clickedWithinSelected = this.isInside(this.mouseClicked);
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        super.mouseReleased(event);
        switch (this.mouseButton) {
            case 1: {
                this.performLeftMouseReleasedAction(event);
                break;
            }
            case 3: {
                this.performRightMouseReleasedAction(event);
                break;
            }
        }
        this.panel.repaint();
    }

    protected void performLeftMouseReleasedAction(MouseEvent event) {
        Point point = event.getPoint();
        Point2D newCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)point, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        Point2D oldCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)this.dragCoord, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        Point2D centerCoordinate = Renderable2DInterface.Util.getWorldCoordinates((Point2D)this.mouseClicked, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        switch (this.panel.getSelectedMode()) {
            case 1: {
                EditorUtilities.selectEditable(newCoordinate, this.panel);
                break;
            }
            case 2: {
                EditorUtilities.instantiateNewEditable(newCoordinate, this.application, this.panel);
                break;
            }
            case 3: {
                EditableRenderable2DInterface selected = this.panel.getSelectedEditableRenderable();
                if (selected == null) break;
                if (this.panel.getSelectedPoint() != null) {
                    EditorUtilities.moveSelectedPoint(selected, newCoordinate, this.panel);
                    break;
                }
                if (!this.clickedWithinSelected) break;
                if (this.panel.getSelectedEditMode() == 1) {
                    EditorUtilities.moveEditable(selected, newCoordinate, oldCoordinate);
                }
                if (this.panel.getSelectedEditMode() != 2) break;
                EditorUtilities.rotateEditable(selected, newCoordinate, centerCoordinate, oldCoordinate);
                break;
            }
        }
    }

    protected void performRightMouseReleasedAction(MouseEvent event) {
        Point2D world = Renderable2DInterface.Util.getWorldCoordinates((Point2D)event.getPoint(), (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        if (this.panel.getSelectedMode() == 1) {
            Renderable2DInterface selected = EditorUtilities.selectEditable(world, this.panel);
            if (selected != null) {
                new IntroSpectionDialog((Object)selected.getSource(), selected.getSource().toString());
            }
        } else if (this.panel.getSelectedMode() == 3 && event.isPopupTrigger()) {
            this.popup(event);
            return;
        }
    }

    private CartesianPoint determineSelectedVertice(Point2D mousePosition) {
        CartesianPoint selectedPoint = null;
        this.panel.setSelectedPoint(null);
        EditableRenderable2DInterface selected = this.panel.getSelectedEditableRenderable();
        if (selected == null) {
            return null;
        }
        Editable editable = (Editable)selected.getSource();
        CartesianPoint[] vertices = editable.getVertices();
        CartesianPoint[] positions = new CartesianPoint[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            positions[i] = EditorUtilities.convertToGlobalCoordinates(vertices[i], editable.getLocation());
            Point2D p1 = Renderable2DInterface.Util.getScreenCoordinates((Point2D)new Point2D.Double(positions[i].x, positions[i].y), (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
            if (!(Math.abs(mousePosition.getX() - (double)((int)p1.getX())) <= 2.0) || !(Math.abs(mousePosition.getY() - (double)((int)p1.getY())) <= 2.0)) continue;
            selectedPoint = vertices[i];
        }
        return selectedPoint;
    }

    private boolean isInside(Point2D mousePosition) {
        EditableRenderable2DInterface selected = this.panel.getSelectedEditableRenderable();
        if (selected == null) {
            return false;
        }
        Point2D worldCoord = Renderable2DInterface.Util.getWorldCoordinates((Point2D)this.mouseClicked, (Rectangle2D)this.panel.getExtent(), (Dimension)this.panel.getSize());
        return selected.contains(worldCoord, this.panel.getExtent(), this.panel.getSize());
    }
}

