/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.UIManager;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.gui.UIInitializer;
import nl.tudelft.simulation.dsol.gui.menu.HelpMenu;
import nl.tudelft.simulation.dsol.gui.panels.ControlPanel;
import nl.tudelft.simulation.dsol.gui.panels.ExperimentTree;
import nl.tudelft.simulation.dsol.gui.panels.Statusbar;
import nl.tudelft.simulation.dsol.gui.panels.TabbedPane;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class DSOLFrame
extends JFrame
implements EventListenerInterface {
    private static SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
    public static final Dimension PREFERRED_SIZE;
    protected DSOLApplicationInterface application = null;
    protected TabbedPane tabbedPanel = null;
    protected JTree experimentTree = null;
    protected Statusbar statusbar = null;
    protected ControlPanel controlPanel = null;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface;
    static /* synthetic */ Class class$java$lang$String;

    public DSOLFrame(DSOLApplicationInterface application, URL navigation) {
        super("DSOL main window");
        try {
            UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            UIInitializer.initialize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((int)Math.round((double)screenSize.width * 0.5 - 0.5 * (double)DSOLFrame.PREFERRED_SIZE.width), (int)Math.round((double)screenSize.height * 0.33 - 0.5 * (double)DSOLFrame.PREFERRED_SIZE.height));
            this.application = application;
            this.setDefaultCloseOperation(3);
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"DSOLFrame", (Throwable)exception);
        }
        this.initialize(navigation);
        this.pack();
        ((Component)this).setVisible(true);
    }

    private void initialize(URL navigation) {
        JPanel contentPane = new JPanel();
        contentPane.setPreferredSize(PREFERRED_SIZE);
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        this.setJMenuBar(this.createMenuBar(navigation));
        this.controlPanel = new ControlPanel(this.application);
        this.tabbedPanel = new TabbedPane(1);
        this.tabbedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder()));
        contentPane.add((Component)this.tabbedPanel, "Center");
        this.statusbar = new Statusbar(this.application);
        this.experimentTree = new JTree();
        this.experimentTree.setEditable(false);
        this.experimentTree.setFocusable(false);
        URL about = URLResource.getResource((String)"/html/about.html");
        JEditorPane aboutPane = null;
        try {
            aboutPane = new JEditorPane(about);
        }
        catch (IOException exception) {
            Logger.warning((Object)this, (String)"initialize", (Throwable)exception);
        }
        aboutPane.setAlignmentY(1.0f);
        aboutPane.setEditable(false);
        this.tabbedPanel.add("About", aboutPane);
    }

    private JMenuBar createMenuBar(URL navigation) {
        Logger.info((Object)this, (String)"createMenuBar", (String)("using " + navigation.toExternalForm()));
        try {
            JMenuBar menuBar = new JMenuBar();
            menuBar.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            Element rootElement = builder.build(navigation).getRootElement();
            Iterator i = rootElement.getChildren("menu").iterator();
            while (i.hasNext()) {
                Element menu = (Element)i.next();
                menuBar.add(this.parseMenu(menu));
            }
            menuBar.add(new HelpMenu(this.application));
            return menuBar;
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"initialze2", (String)exception.getMessage());
            return null;
        }
    }

    private JMenu parseMenu(Element element) throws Exception {
        JMenu menu = new JMenu(element.getAttributeValue("name"));
        Iterator i = element.getChildren().iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            if (child.getName().equals("menu")) {
                menu.add(this.parseMenu(child));
                continue;
            }
            if (child.getName().equals("separator")) {
                menu.add(new JSeparator());
                continue;
            }
            if (!child.getName().equals("action")) continue;
            Class<?> actionClass = Class.forName(child.getAttributeValue("className"));
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(this.application);
            Iterator ii = child.getChildren("argument").iterator();
            while (ii.hasNext()) {
                arguments.add(((Element)ii.next()).getValue());
            }
            Class[] argumentClasses = new Class[arguments.size()];
            argumentClasses[0] = class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface == null ? DSOLFrame.class$("nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface") : class$nl$tudelft$simulation$dsol$gui$DSOLApplicationInterface;
            for (int loop = 0; loop < argumentClasses.length - 1; ++loop) {
                argumentClasses[loop + 1] = class$java$lang$String == null ? DSOLFrame.class$("java.lang.String") : class$java$lang$String;
            }
            Constructor actionConstructor = ClassUtil.resolveConstructor(actionClass, (Class[])argumentClasses);
            Object action = actionConstructor.newInstance(arguments.toArray());
            if (action instanceof Action) {
                menu.add((Action)action);
                continue;
            }
            if (!(action instanceof JMenu)) continue;
            menu.add((JMenu)action);
        }
        return menu;
    }

    public void notify(EventInterface event) {
        if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
            this.tabbedPanel.remove("Description");
            this.tabbedPanel.remove("Experiment");
            this.tabbedPanel.remove("Control");
            if (event.getContent() != null) {
                Experiment experiment = (Experiment)event.getContent();
                try {
                    String descriptionName = "/";
                    if (experiment.getModel().getClass().getPackage() != null) {
                        descriptionName = descriptionName + experiment.getModel().getClass().getPackage().getName().replace('.', '/');
                    }
                    descriptionName = descriptionName + "/package.html";
                    URL description = experiment.getModel().getClass().getResource(descriptionName);
                    JEditorPane descriptionPane = null;
                    descriptionPane = new JEditorPane(description);
                    descriptionPane.setAlignmentY(1.0f);
                    descriptionPane.setEditable(false);
                    this.tabbedPanel.add("Description", 0, new JScrollPane(descriptionPane));
                }
                catch (IOException exception) {
                    Logger.fine((Object)this, (String)"initialize", (String)"experiment has no package.html describing the experiment");
                }
                this.setTitle("DSOL main window (" + experiment.getProperty("EXPERIMENT_NAME") + ")");
                this.experimentTree.setModel(new ExperimentTree(experiment));
                this.tabbedPanel.add("Experiment", 1, new JScrollPane(this.experimentTree));
                this.tabbedPanel.add("Control", 2, this.controlPanel);
                this.getContentPane().add((Component)this.statusbar, "South");
            } else {
                this.setTitle("DSOL main window");
                this.getContentPane().remove(this.statusbar);
            }
            this.validate();
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        builder.setFeature("http://xml.org/sax/features/validation", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        String xsd = URLResource.getResource((String)"/navigation.xsd").toExternalForm();
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.simulation.tudelft.nl/dsol " + xsd));
        PREFERRED_SIZE = new Dimension(400, 375);
    }
}

