/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.gui.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.dsol.eventlists.EventListInterface;
import nl.tudelft.simulation.dsol.eventlists.TableModelEventList;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.gui.DSOLApplicationInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;

public class EventlistFrame
extends JFrame
implements EventListenerInterface {
    private DSOLApplicationInterface application = null;
    private DEVSSimulatorInterface simulator = null;
    private SynchronizedJTable table = new SynchronizedJTable(new DefaultTableModel(TableModelEventList.HEADER, 0));

    public EventlistFrame(DSOLApplicationInterface application) {
        super("Eventlist");
        this.application = application;
        this.initialize();
        try {
            this.application.addListener(this, DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT);
            this.notify((EventInterface)new Event(DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT, (Object)this.application, (Object)this.application.getExperiment()));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"EventlistFrame", (Throwable)exception);
        }
        this.pack();
        ((Component)this).setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block7: {
            try {
                if (this.simulator == null || !(this.simulator.getEventList() instanceof TableModelEventList)) break block7;
                boolean stopped = false;
                if (this.simulator.isRunning()) {
                    stopped = true;
                    this.simulator.stop();
                }
                DEVSSimulatorInterface dEVSSimulatorInterface = this.simulator;
                synchronized (dEVSSimulatorInterface) {
                    this.simulator.removeListener((EventListenerInterface)this, DEVSSimulatorInterface.EVENTLIST_CHANGED_EVENT);
                    this.undoSwapEventList();
                    if (stopped) {
                        this.simulator.start();
                    }
                }
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"dispose", (Throwable)exception);
            }
        }
        super.dispose();
    }

    private void initialize() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)new JScrollPane(this.table), "Center");
        panel.setPreferredSize(new Dimension(700, 300));
        this.setContentPane(panel);
    }

    public void notify(EventInterface event) {
        try {
            if (event.getSource().equals(this.application) && event.getType().equals((Object)DSOLApplicationInterface.EXPERIMENT_CHANGED_EVENT)) {
                if (event.getContent() != null) {
                    Experiment experiment = (Experiment)event.getContent();
                    experiment.addListener((EventListenerInterface)this, Experiment.SIMULATOR_CHANGED_EVENT);
                    this.notify((EventInterface)new Event(Experiment.SIMULATOR_CHANGED_EVENT, (Object)experiment, (Object)experiment.getSimulator()));
                }
                return;
            }
            if (event.getSource() instanceof Experiment && event.getType().equals((Object)Experiment.SIMULATOR_CHANGED_EVENT) && event.getContent() != null && event.getContent() instanceof DEVSSimulatorInterface) {
                this.simulator = (DEVSSimulatorInterface)event.getContent();
                this.simulator.addListener((EventListenerInterface)this, DEVSSimulatorInterface.EVENTLIST_CHANGED_EVENT);
                this.notify((EventInterface)new Event(DEVSSimulatorInterface.EVENTLIST_CHANGED_EVENT, (Object)this.simulator, (Object)this.simulator.getEventList()));
            }
            if (event.getSource().equals(this.simulator) && event.getType().equals((Object)DEVSSimulatorInterface.EVENTLIST_CHANGED_EVENT)) {
                if (!(this.simulator.getEventList() instanceof TableModelEventList)) {
                    this.swapEventList();
                } else {
                    this.table.setModel(((TableModelEventList)this.simulator.getEventList()).getTableModel());
                }
            }
            return;
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"dispose", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoSwapEventList() throws Exception {
        if (this.simulator != null) {
            boolean stopped = false;
            if (this.simulator.isRunning()) {
                stopped = true;
                this.simulator.stop();
            }
            DEVSSimulatorInterface dEVSSimulatorInterface = this.simulator;
            synchronized (dEVSSimulatorInterface) {
                if (this.simulator.getEventList() instanceof TableModelEventList) {
                    this.simulator.setEventList(((TableModelEventList)this.simulator.getEventList()).getOrigin());
                }
                this.table.setModel(new DefaultTableModel(TableModelEventList.HEADER, 0));
                if (stopped) {
                    this.simulator.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapEventList() throws Exception {
        if (this.simulator != null) {
            boolean stopped = false;
            if (this.simulator.isRunning()) {
                stopped = true;
                this.simulator.stop();
            }
            DEVSSimulatorInterface dEVSSimulatorInterface = this.simulator;
            synchronized (dEVSSimulatorInterface) {
                TableModelEventList eventList = null;
                DEVSSimulatorInterface dEVSSimulatorInterface2 = this.simulator;
                synchronized (dEVSSimulatorInterface2) {
                    eventList = new TableModelEventList(this.simulator.getEventList());
                    this.simulator.setEventList((EventListInterface)eventList);
                }
                this.table.setModel(eventList.getTableModel());
                if (stopped) {
                    this.simulator.start();
                }
            }
        }
    }

    private static class SynchronizedJTable
    extends JTable {
        public SynchronizedJTable(TableModel dm) {
            super(dm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            TableModel tableModel = this.getModel();
            synchronized (tableModel) {
                super.paint(g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics g) {
            TableModel tableModel = this.getModel();
            synchronized (tableModel) {
                super.paintComponent(g);
            }
        }
    }
}

