/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;

public class Shape3DState
extends LeafState {
    private int[] geometry;
    private int appearance;

    public Shape3DState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.appearance = controller.getSymbolTable().addReference((SceneGraphObject)((Shape3D)this.node).getAppearance());
            int n = ((Shape3D)this.node).numGeometries();
            this.geometry = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.geometry[n2] = controller.getSymbolTable().addReference((SceneGraphObject)((Shape3D)this.node).getGeometry(n2));
                ++n2;
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Shape3D)this.node).getCollisionBounds());
        dataOutput.writeInt(this.appearance);
        dataOutput.writeInt(this.geometry.length);
        int n = 0;
        while (n < this.geometry.length) {
            dataOutput.writeInt(this.geometry[n]);
            ++n;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Shape3D)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        this.appearance = dataInput.readInt();
        this.geometry = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.geometry.length) {
            this.geometry[n] = dataInput.readInt();
            ++n;
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
    }

    public void buildGraph() {
        ((Shape3D)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        ((Shape3D)this.node).setGeometry((Geometry)this.control.getSymbolTable().getJ3dNode(this.geometry[0]));
        int n = 1;
        while (n < this.geometry.length) {
            ((Shape3D)this.node).addGeometry((Geometry)this.control.getSymbolTable().getJ3dNode(this.geometry[n]));
            ++n;
        }
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Shape3D();
    }
}

