/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;

public class TextureAttributesState
extends NodeComponentState {
    private static final int MAX_COLOR_OPERANDS = 2;

    public TextureAttributesState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        Color4f color4f = new Color4f();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D = new Transform3D();
        int n = textureAttributes.getNumTextureColorTableComponents();
        int n2 = textureAttributes.getTextureColorTableSize();
        int[][] nArray = new int[n][n2];
        dataOutput.writeInt(textureAttributes.getPerspectiveCorrectionMode());
        textureAttributes.getTextureBlendColor(color4f);
        this.control.writeColor4f(dataOutput, color4f);
        dataOutput.writeInt(n);
        dataOutput.writeInt(n2);
        textureAttributes.getTextureColorTable(nArray);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dataOutput.writeInt(nArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        dataOutput.writeInt(textureAttributes.getTextureMode());
        textureAttributes.getTextureTransform(transform3D);
        transform3D.get(matrix4d);
        this.control.writeMatrix4d(dataOutput, matrix4d);
        dataOutput.writeInt(textureAttributes.getCombineRgbMode());
        dataOutput.writeInt(textureAttributes.getCombineAlphaMode());
        int n5 = 0;
        while (n5 < 2) {
            dataOutput.writeInt(textureAttributes.getCombineRgbSource(n5));
            dataOutput.writeInt(textureAttributes.getCombineAlphaSource(n5));
            dataOutput.writeInt(textureAttributes.getCombineRgbFunction(n5));
            dataOutput.writeInt(textureAttributes.getCombineAlphaFunction(n5));
            ++n5;
        }
        dataOutput.writeInt(textureAttributes.getCombineRgbScale());
        dataOutput.writeInt(textureAttributes.getCombineAlphaScale());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        textureAttributes.setPerspectiveCorrectionMode(dataInput.readInt());
        textureAttributes.setTextureBlendColor(this.control.readColor4f(dataInput));
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int[][] nArray = new int[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                nArray[n3][n4] = dataInput.readInt();
                ++n4;
            }
            ++n3;
        }
        if (n != 0) {
            textureAttributes.setTextureColorTable(nArray);
        }
        textureAttributes.setTextureMode(dataInput.readInt());
        Matrix4d matrix4d = this.control.readMatrix4d(dataInput);
        Transform3D transform3D = new Transform3D(matrix4d);
        textureAttributes.setTextureTransform(transform3D);
        textureAttributes.setCombineRgbMode(dataInput.readInt());
        textureAttributes.setCombineAlphaMode(dataInput.readInt());
        int n5 = 0;
        while (n5 < 2) {
            textureAttributes.setCombineRgbSource(n5, dataInput.readInt());
            textureAttributes.setCombineAlphaSource(n5, dataInput.readInt());
            textureAttributes.setCombineRgbFunction(n5, dataInput.readInt());
            textureAttributes.setCombineAlphaFunction(n5, dataInput.readInt());
            ++n5;
        }
        textureAttributes.setCombineRgbScale(dataInput.readInt());
        textureAttributes.setCombineAlphaScale(dataInput.readInt());
    }

    protected SceneGraphObject createNode() {
        return new TextureAttributes();
    }
}

