/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureCubeMap;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public abstract class TextureState
extends NodeComponentState {
    private int[] imageComponents;
    protected int width;
    protected int height;
    protected int format;
    protected int mipMapMode;
    protected int boundaryWidth;

    public TextureState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null && !(this.node instanceof TextureCubeMap)) {
            ImageComponent[] imageComponentArray = ((Texture)this.node).getImages();
            this.imageComponents = new int[imageComponentArray.length];
            int n = 0;
            while (n < imageComponentArray.length) {
                this.imageComponents[n] = controller.getSymbolTable().addReference((SceneGraphObject)imageComponentArray[n]);
                ++n;
            }
        }
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeInt(((Texture)this.node).getMipMapMode());
        dataOutput.writeInt(((Texture)this.node).getWidth());
        dataOutput.writeInt(((Texture)this.node).getHeight());
        dataOutput.writeInt(((Texture)this.node).getFormat());
        dataOutput.writeInt(((Texture)this.node).getBoundaryWidth());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.mipMapMode = dataInput.readInt();
        this.width = dataInput.readInt();
        this.height = dataInput.readInt();
        this.format = dataInput.readInt();
        this.boundaryWidth = dataInput.readInt();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        float[] fArray;
        super.writeObject(dataOutput);
        Texture texture = (Texture)this.node;
        Color4f color4f = new Color4f();
        texture.getBoundaryColor(color4f);
        this.control.writeColor4f(dataOutput, color4f);
        dataOutput.writeInt(texture.getBoundaryModeS());
        dataOutput.writeInt(texture.getBoundaryModeT());
        dataOutput.writeBoolean(texture.getEnable());
        dataOutput.writeInt(this.imageComponents.length);
        int n = 0;
        while (n < this.imageComponents.length) {
            dataOutput.writeInt(this.imageComponents[n]);
            ++n;
        }
        dataOutput.writeInt(texture.getMagFilter());
        dataOutput.writeInt(texture.getMinFilter());
        dataOutput.writeInt(texture.getBaseLevel());
        dataOutput.writeInt(texture.getMaximumLevel());
        dataOutput.writeFloat(texture.getMinimumLOD());
        dataOutput.writeFloat(texture.getMaximumLOD());
        Point3f point3f = new Point3f();
        texture.getLodOffset((Tuple3f)point3f);
        this.control.writePoint3f(dataOutput, point3f);
        dataOutput.writeInt(texture.getAnisotropicFilterMode());
        dataOutput.writeFloat(texture.getAnisotropicFilterDegree());
        int n2 = texture.getSharpenTextureFuncPointsCount();
        dataOutput.writeInt(n2);
        if (n2 > 0) {
            fArray = new float[n2];
            float[] fArray2 = new float[n2];
            texture.getSharpenTextureFunc(fArray, fArray2);
            int n3 = 0;
            while (n3 < n2) {
                dataOutput.writeFloat(fArray[n3]);
                dataOutput.writeFloat(fArray2[n3]);
                ++n3;
            }
        }
        n2 = texture.getFilter4FuncPointsCount();
        dataOutput.writeInt(n2);
        if (n2 >= 4) {
            fArray = new float[n2];
            texture.getFilter4Func(fArray);
            int n4 = 0;
            while (n4 < n2) {
                dataOutput.writeFloat(fArray[n4]);
                ++n4;
            }
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        float[] fArray;
        super.readObject(dataInput);
        Texture texture = (Texture)this.node;
        texture.setBoundaryColor(this.control.readColor4f(dataInput));
        texture.setBoundaryModeS(dataInput.readInt());
        texture.setBoundaryModeT(dataInput.readInt());
        texture.setEnable(dataInput.readBoolean());
        this.imageComponents = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.imageComponents.length) {
            this.imageComponents[n] = dataInput.readInt();
            ++n;
        }
        int n2 = dataInput.readInt();
        try {
            texture.setMagFilter(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (n2 == 5) {
                texture.setMagFilter(3);
            }
            if (n2 == 4) {
                texture.setMagFilter(2);
            }
            texture.setMagFilter(0);
        }
        texture.setMinFilter(dataInput.readInt());
        texture.setBaseLevel(dataInput.readInt());
        texture.setMaximumLevel(dataInput.readInt());
        texture.setMinimumLOD(dataInput.readFloat());
        texture.setMaximumLOD(dataInput.readFloat());
        texture.setLodOffset((Tuple3f)this.control.readPoint3f(dataInput));
        texture.setAnisotropicFilterMode(dataInput.readInt());
        texture.setAnisotropicFilterDegree(dataInput.readFloat());
        int n3 = dataInput.readInt();
        if (n3 > 0) {
            fArray = new float[n3];
            float[] fArray2 = new float[n3];
            int n4 = 0;
            while (n4 < n3) {
                fArray[n4] = dataInput.readFloat();
                fArray2[n4] = dataInput.readFloat();
                ++n4;
            }
            texture.setSharpenTextureFunc(fArray, fArray2);
        }
        if ((n3 = dataInput.readInt()) >= 4) {
            fArray = new float[n3];
            int n5 = 0;
            while (n5 < n3) {
                fArray[n5] = dataInput.readFloat();
                ++n5;
            }
            texture.setFilter4Func(fArray);
        }
    }

    public void addSubReference() {
        if (!(this.node instanceof TextureCubeMap)) {
            int n = 0;
            while (n < this.imageComponents.length) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.imageComponents[n]);
                ++n;
            }
        }
    }

    public void buildGraph() {
        if (!(this.node instanceof TextureCubeMap)) {
            int n = 0;
            while (n < this.imageComponents.length) {
                ((Texture)this.node).setImage(n, (ImageComponent)this.control.getSymbolTable().getJ3dNode(this.imageComponents[n]));
                ++n;
            }
        }
        super.buildGraph();
    }
}

