/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ViewInfo {
    private static final boolean verbose = false;
    public static final int SCREEN_AUTO_UPDATE = 1;
    public static final int CANVAS_AUTO_UPDATE = 2;
    public static final int VIEW_AUTO_UPDATE = 4;
    public static final int HEAD_AUTO_UPDATE = 8;
    public static final int PLATFORM_AUTO_UPDATE = 16;
    private static Map staticVpMap = new HashMap();
    private static Map staticSiMap = new HashMap();
    private Map screenMap = null;
    private Map viewPlatformMap = null;
    private View view = null;
    private Sensor headTracker = null;
    private boolean useTracking = false;
    private boolean clipVirtual = false;
    private ViewPlatformInfo vpi = null;
    private int canvasCount = 0;
    private Map canvasMap = new HashMap();
    private CanvasInfo[] canvasInfo = new CanvasInfo[1];
    private boolean updateView = true;
    private boolean updateHead = true;
    private boolean autoUpdate = false;
    private int autoUpdateFlags = 0;
    private int viewPolicy = 0;
    private int resizePolicy = 1;
    private int movementPolicy = 1;
    private int eyePolicy = 2;
    private int projectionPolicy = 1;
    private int frontClipPolicy = 3;
    private int backClipPolicy = 3;
    private int scalePolicy = 0;
    private boolean coeCentering = true;
    private Transform3D coeToTrackerBase = null;
    private Transform3D headToHeadTracker = null;
    private Transform3D headTrackerToTrackerBase = null;
    private Transform3D trackerBaseToHeadTracker = null;
    private Transform3D headToTrackerBase = null;
    private Transform3D coeToHeadTracker = null;
    private PhysicalEnvironment env = null;
    private PhysicalBody body = null;
    private Point3d leftEyeInHead = new Point3d();
    private Point3d rightEyeInHead = new Point3d();
    private Vector3d v3d = new Vector3d();
    private double[] m16d = new double[16];
    private Point3d leftEye = new Point3d();
    private Point3d rightEye = new Point3d();
    private Map newMap = new HashMap();
    private Set newSet = new HashSet();

    public ViewInfo(View view) {
        this(view, 0);
    }

    public ViewInfo(View view, int n) {
        this(view, n, staticSiMap, staticVpMap);
    }

    public ViewInfo(View view, int n, Map map, Map map2) {
        if (view == null) {
            throw new IllegalArgumentException("View is null");
        }
        if (map == null) {
            throw new IllegalArgumentException("screenMap is null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("viewPlatformMap is null");
        }
        this.view = view;
        this.screenMap = map;
        this.viewPlatformMap = map2;
        if (n == 0) {
            this.autoUpdate = false;
        } else {
            this.autoUpdate = true;
            this.autoUpdateFlags = n;
        }
        this.getViewInfo();
    }

    public void getImagePlateToViewPlatform(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getImagePlateToViewPlatform", false);
        this.getImagePlateToViewPlatform(canvasInfo);
        transform3D.set(canvasInfo.plateToViewPlatform);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightPlateToViewPlatform);
        }
    }

    private void getImagePlateToViewPlatform(CanvasInfo canvasInfo) {
        if (canvasInfo.updatePlateToViewPlatform) {
            if (canvasInfo.plateToViewPlatform == null) {
                canvasInfo.plateToViewPlatform = new Transform3D();
            }
            this.getCoexistenceToImagePlate(canvasInfo);
            this.getViewPlatformToCoexistence(canvasInfo);
            canvasInfo.plateToViewPlatform.mul(canvasInfo.coeToPlate, canvasInfo.viewPlatformToCoe);
            canvasInfo.plateToViewPlatform.invert();
            if (canvasInfo.useStereo) {
                if (canvasInfo.rightPlateToViewPlatform == null) {
                    canvasInfo.rightPlateToViewPlatform = new Transform3D();
                }
                canvasInfo.rightPlateToViewPlatform.mul(canvasInfo.coeToRightPlate, canvasInfo.viewPlatformToCoe);
                canvasInfo.rightPlateToViewPlatform.invert();
            }
            canvasInfo.updatePlateToViewPlatform = false;
        }
    }

    public void getImagePlateToVworld(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getImagePlateToVworld", true);
        this.getImagePlateToVworld(canvasInfo);
        transform3D.set(canvasInfo.plateToVworld);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightPlateToVworld);
        }
    }

    private void getImagePlateToVworld(CanvasInfo canvasInfo) {
        if (canvasInfo.updatePlateToVworld) {
            if (canvasInfo.plateToVworld == null) {
                canvasInfo.plateToVworld = new Transform3D();
            }
            this.getImagePlateToViewPlatform(canvasInfo);
            canvasInfo.plateToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.plateToViewPlatform);
            if (canvasInfo.useStereo) {
                if (canvasInfo.rightPlateToVworld == null) {
                    canvasInfo.rightPlateToVworld = new Transform3D();
                }
                canvasInfo.rightPlateToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.rightPlateToViewPlatform);
            }
            canvasInfo.updatePlateToVworld = false;
        }
    }

    public void getCoexistenceToImagePlate(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getCoexistenceToImagePlate", false);
        this.getCoexistenceToImagePlate(canvasInfo);
        transform3D.set(canvasInfo.coeToPlate);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.coeToRightPlate);
        }
    }

    private void getCoexistenceToImagePlate(CanvasInfo canvasInfo) {
        if (canvasInfo.updateCoeToPlate) {
            if (canvasInfo.coeToPlate == null) {
                canvasInfo.coeToPlate = new Transform3D();
                canvasInfo.coeToRightPlate = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                canvasInfo.coeToPlate.mul(canvasInfo.si.headTrackerToLeftPlate, this.coeToHeadTracker);
                if (canvasInfo.useStereo) {
                    canvasInfo.coeToRightPlate.mul(canvasInfo.si.headTrackerToRightPlate, this.coeToHeadTracker);
                } else {
                    canvasInfo.coeToRightPlate.set(canvasInfo.coeToPlate);
                }
            } else if (this.coeCentering) {
                if (this.movementPolicy == 1) {
                    this.v3d.set(canvasInfo.canvasX + canvasInfo.canvasWidth / 2.0, canvasInfo.canvasY + canvasInfo.canvasHeight / 2.0, 0.0);
                } else {
                    this.v3d.set(canvasInfo.si.screenWidth / 2.0, canvasInfo.si.screenHeight / 2.0, 0.0);
                }
                canvasInfo.coeToPlate.set(this.v3d);
                canvasInfo.coeToRightPlate.set(this.v3d);
            } else {
                canvasInfo.coeToPlate.mul(canvasInfo.si.trackerBaseToPlate, this.coeToTrackerBase);
                canvasInfo.coeToRightPlate.set(canvasInfo.coeToPlate);
            }
            canvasInfo.updateCoeToPlate = false;
        }
    }

    public void getViewPlatformToCoexistence(Canvas3D canvas3D, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getViewPlatformToCoexistence", false);
        this.getViewPlatformToCoexistence(canvasInfo);
        transform3D.set(canvasInfo.viewPlatformToCoe);
    }

    private void getViewPlatformToCoexistence(CanvasInfo canvasInfo) {
        if (!canvasInfo.updateViewPlatformToCoe) {
            return;
        }
        if (canvasInfo.viewPlatformToCoe == null) {
            canvasInfo.viewPlatformToCoe = new Transform3D();
        }
        this.getScreenScale(canvasInfo);
        if (this.resizePolicy == 1) {
            canvasInfo.viewPlatformToCoe.setScale(canvasInfo.screenScale * canvasInfo.windowScale);
        } else {
            canvasInfo.viewPlatformToCoe.setScale(canvasInfo.screenScale);
        }
        if (this.viewPolicy == 1) {
            canvasInfo.updateViewPlatformToCoe = false;
            return;
        }
        double d = this.body.getNominalEyeHeightFromGround();
        int n = this.view.getViewPlatform().getViewAttachPolicy();
        int n2 = this.env.getCoexistenceCenterInPworldPolicy();
        double d2 = this.eyePolicy == 2 ? canvasInfo.getFieldOfViewOffset() : this.body.getNominalEyeOffsetFromNominalScreen();
        if (n2 == 2) {
            if (n == 0) {
                this.v3d.set(0.0, 0.0, d2);
            } else if (n == 2) {
                this.v3d.set(0.0, 0.0, 0.0);
            } else {
                this.v3d.set(0.0, -d, d2);
            }
        } else if (n2 == 0) {
            if (n == 0) {
                this.v3d.set(0.0, 0.0, 0.0);
            } else if (n == 2) {
                this.v3d.set(0.0, 0.0, -d2);
            } else {
                this.v3d.set(0.0, -d, 0.0);
            }
        } else if (n == 0) {
            this.v3d.set(0.0, d, 0.0);
        } else if (n == 2) {
            this.v3d.set(0.0, d, -d2);
        } else {
            this.v3d.set(0.0, 0.0, 0.0);
        }
        canvasInfo.viewPlatformToCoe.setTranslation(this.v3d);
        canvasInfo.updateViewPlatformToCoe = false;
    }

    public void getCoexistenceToViewPlatform(Canvas3D canvas3D, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getCoexistenceToViewPlatform", false);
        this.getCoexistenceToViewPlatform(canvasInfo);
        transform3D.set(canvasInfo.coeToViewPlatform);
    }

    private void getCoexistenceToViewPlatform(CanvasInfo canvasInfo) {
        if (canvasInfo.updateCoeToViewPlatform) {
            if (canvasInfo.coeToViewPlatform == null) {
                canvasInfo.coeToViewPlatform = new Transform3D();
            }
            this.getViewPlatformToCoexistence(canvasInfo);
            canvasInfo.coeToViewPlatform.invert(canvasInfo.viewPlatformToCoe);
            canvasInfo.updateCoeToViewPlatform = false;
        }
    }

    public void getCoexistenceToVworld(Canvas3D canvas3D, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getCoexistenceToVworld", true);
        this.getCoexistenceToVworld(canvasInfo);
        transform3D.set(canvasInfo.coeToVworld);
    }

    private void getCoexistenceToVworld(CanvasInfo canvasInfo) {
        if (canvasInfo.updateCoeToVworld) {
            if (canvasInfo.coeToVworld == null) {
                canvasInfo.coeToVworld = new Transform3D();
            }
            this.getCoexistenceToViewPlatform(canvasInfo);
            canvasInfo.coeToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.coeToViewPlatform);
            canvasInfo.updateCoeToVworld = false;
        }
    }

    public void getEyeToImagePlate(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getEyeToImagePlate", false);
        this.getEyeToImagePlate(canvasInfo);
        transform3D.set(canvasInfo.eyeToPlate);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightEyeToPlate);
        }
    }

    private void getEyeToImagePlate(CanvasInfo canvasInfo) {
        if (canvasInfo.updateEyeInPlate) {
            if (canvasInfo.eyeToPlate == null) {
                canvasInfo.eyeToPlate = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                this.getEyesHMD(canvasInfo);
            } else if (this.useTracking) {
                this.getEyesTracked(canvasInfo);
            } else {
                this.getEyesFixedScreen(canvasInfo);
            }
            canvasInfo.updateEyeInPlate = false;
        }
    }

    private void getEyesHMD(CanvasInfo canvasInfo) {
        if (canvasInfo.useStereo) {
            this.leftEye.set((Tuple3d)this.leftEyeInHead);
            this.headToHeadTracker.transform(this.leftEye);
            canvasInfo.si.headTrackerToLeftPlate.transform(this.leftEye, canvasInfo.eyeInPlate);
            this.rightEye.set((Tuple3d)this.rightEyeInHead);
            this.headToHeadTracker.transform(this.rightEye);
            canvasInfo.si.headTrackerToRightPlate.transform(this.rightEye, canvasInfo.rightEyeInPlate);
            if (canvasInfo.rightEyeToPlate == null) {
                canvasInfo.rightEyeToPlate = new Transform3D();
            }
            this.v3d.set((Tuple3d)canvasInfo.rightEyeInPlate);
            canvasInfo.rightEyeToPlate.set(this.v3d);
        } else {
            switch (canvasInfo.monoscopicPolicy) {
                case 0: {
                    this.leftEye.set((Tuple3d)this.leftEyeInHead);
                    this.headToHeadTracker.transform(this.leftEye);
                    canvasInfo.si.headTrackerToLeftPlate.transform(this.leftEye, canvasInfo.eyeInPlate);
                    break;
                }
                case 1: {
                    this.rightEye.set((Tuple3d)this.rightEyeInHead);
                    this.headToHeadTracker.transform(this.rightEye);
                    canvasInfo.si.headTrackerToRightPlate.transform(this.rightEye, canvasInfo.eyeInPlate);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal monoscopic view policy for 2-channel HMD");
                }
            }
        }
        this.v3d.set((Tuple3d)canvasInfo.eyeInPlate);
        canvasInfo.eyeToPlate.set(this.v3d);
    }

    private void getEyesTracked(CanvasInfo canvasInfo) {
        this.leftEye.set((Tuple3d)this.leftEyeInHead);
        this.rightEye.set((Tuple3d)this.rightEyeInHead);
        this.headToTrackerBase.transform(this.leftEye);
        this.headToTrackerBase.transform(this.rightEye);
        if (this.coeCentering) {
            this.getCoexistenceToImagePlate(canvasInfo);
            canvasInfo.coeToPlate.transform(this.leftEye);
            canvasInfo.coeToRightPlate.transform(this.rightEye);
        } else {
            canvasInfo.si.trackerBaseToPlate.transform(this.leftEye);
            canvasInfo.si.trackerBaseToPlate.transform(this.rightEye);
        }
        this.setEyeScreenRelative(canvasInfo, this.leftEye, this.rightEye);
    }

    private void getEyesFixedScreen(CanvasInfo canvasInfo) {
        switch (this.eyePolicy) {
            case 2: {
                double d = canvasInfo.getFieldOfViewOffset();
                this.setEyeWindowRelative(canvasInfo, d, d);
                break;
            }
            case 1: {
                this.setEyeWindowRelative(canvasInfo, ((CanvasInfo)canvasInfo).leftManualEyeInPlate.z, ((CanvasInfo)canvasInfo).rightManualEyeInPlate.z);
                break;
            }
            case 0: {
                this.setEyeScreenRelative(canvasInfo, canvasInfo.leftManualEyeInPlate, canvasInfo.rightManualEyeInPlate);
                break;
            }
            case 3: {
                this.view.getLeftManualEyeInCoexistence(this.leftEye);
                this.view.getRightManualEyeInCoexistence(this.rightEye);
                this.getCoexistenceToImagePlate(canvasInfo);
                canvasInfo.coeToPlate.transform(this.leftEye);
                canvasInfo.coeToRightPlate.transform(this.rightEye);
                this.setEyeScreenRelative(canvasInfo, this.leftEye, this.rightEye);
            }
        }
    }

    private void setEyeWindowRelative(CanvasInfo canvasInfo, double d, double d2) {
        double d3 = canvasInfo.canvasX + canvasInfo.canvasWidth / 2.0;
        this.leftEye.x = d3 + this.leftEyeInHead.x;
        this.rightEye.x = d3 + this.rightEyeInHead.x;
        this.leftEye.y = this.rightEye.y = canvasInfo.canvasY + canvasInfo.canvasHeight / 2.0;
        this.leftEye.z = d;
        this.rightEye.z = d2;
        this.setEyeScreenRelative(canvasInfo, this.leftEye, this.rightEye);
    }

    private void setEyeScreenRelative(CanvasInfo canvasInfo, Point3d point3d, Point3d point3d2) {
        if (canvasInfo.useStereo) {
            canvasInfo.eyeInPlate.set((Tuple3d)point3d);
            canvasInfo.rightEyeInPlate.set((Tuple3d)point3d2);
            if (canvasInfo.rightEyeToPlate == null) {
                canvasInfo.rightEyeToPlate = new Transform3D();
            }
            this.v3d.set((Tuple3d)canvasInfo.rightEyeInPlate);
            canvasInfo.rightEyeToPlate.set(this.v3d);
        } else {
            switch (canvasInfo.monoscopicPolicy) {
                case 2: {
                    canvasInfo.eyeInPlate.set((point3d.x + point3d2.x) / 2.0, (point3d.y + point3d2.y) / 2.0, (point3d.z + point3d2.z) / 2.0);
                    break;
                }
                case 0: {
                    canvasInfo.eyeInPlate.set((Tuple3d)point3d);
                    break;
                }
                case 1: {
                    canvasInfo.eyeInPlate.set((Tuple3d)point3d2);
                }
            }
        }
        this.v3d.set((Tuple3d)canvasInfo.eyeInPlate);
        canvasInfo.eyeToPlate.set(this.v3d);
    }

    public void getEyeToViewPlatform(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getEyeToViewPlatform", false);
        this.getEyeToViewPlatform(canvasInfo);
        transform3D.set(canvasInfo.eyeToViewPlatform);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightEyeToViewPlatform);
        }
    }

    private void getEyeToViewPlatform(CanvasInfo canvasInfo) {
        if (canvasInfo.updateEyeToViewPlatform) {
            if (canvasInfo.eyeToViewPlatform == null) {
                canvasInfo.eyeToViewPlatform = new Transform3D();
            }
            this.getEyeToImagePlate(canvasInfo);
            this.getImagePlateToViewPlatform(canvasInfo);
            canvasInfo.eyeToViewPlatform.mul(canvasInfo.plateToViewPlatform, canvasInfo.eyeToPlate);
            if (canvasInfo.useStereo) {
                if (canvasInfo.rightEyeToViewPlatform == null) {
                    canvasInfo.rightEyeToViewPlatform = new Transform3D();
                }
                canvasInfo.rightEyeToViewPlatform.mul(canvasInfo.rightPlateToViewPlatform, canvasInfo.rightEyeToPlate);
            }
            canvasInfo.updateEyeToViewPlatform = false;
        }
    }

    public void getViewPlatformToEye(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getViewPlatformToEye", false);
        this.getViewPlatformToEye(canvasInfo);
        transform3D.set(canvasInfo.viewPlatformToEye);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.viewPlatformToRightEye);
        }
    }

    private void getViewPlatformToEye(CanvasInfo canvasInfo) {
        if (canvasInfo.updateViewPlatformToEye) {
            if (canvasInfo.viewPlatformToEye == null) {
                canvasInfo.viewPlatformToEye = new Transform3D();
            }
            this.getEyeToViewPlatform(canvasInfo);
            canvasInfo.viewPlatformToEye.invert(canvasInfo.eyeToViewPlatform);
            if (canvasInfo.useStereo) {
                if (canvasInfo.viewPlatformToRightEye == null) {
                    canvasInfo.viewPlatformToRightEye = new Transform3D();
                }
                canvasInfo.viewPlatformToRightEye.invert(canvasInfo.rightEyeToViewPlatform);
            }
            canvasInfo.updateViewPlatformToEye = false;
        }
    }

    public void getEyeToVworld(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getEyeToVworld", true);
        this.getEyeToVworld(canvasInfo);
        transform3D.set(canvasInfo.eyeToVworld);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightEyeToVworld);
        }
    }

    private void getEyeToVworld(CanvasInfo canvasInfo) {
        if (canvasInfo.updateEyeToVworld) {
            if (canvasInfo.eyeToVworld == null) {
                canvasInfo.eyeToVworld = new Transform3D();
            }
            this.getEyeToViewPlatform(canvasInfo);
            canvasInfo.eyeToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.eyeToViewPlatform);
            if (canvasInfo.useStereo) {
                if (canvasInfo.rightEyeToVworld == null) {
                    canvasInfo.rightEyeToVworld = new Transform3D();
                }
                canvasInfo.rightEyeToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.rightEyeToViewPlatform);
            }
            canvasInfo.updateEyeToVworld = false;
        }
    }

    public void getProjection(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getProjection", true);
        this.getProjection(canvasInfo);
        transform3D.set(canvasInfo.projection);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.rightProjection);
        }
    }

    private void getProjection(CanvasInfo canvasInfo) {
        if (canvasInfo.updateProjection) {
            if (canvasInfo.projection == null) {
                canvasInfo.projection = new Transform3D();
            }
            this.getEyeToImagePlate(canvasInfo);
            this.getClipDistances(canvasInfo);
            double d = this.getBackClip(canvasInfo, canvasInfo.eyeInPlate);
            this.computeProjection(canvasInfo, canvasInfo.eyeInPlate, this.getFrontClip(canvasInfo, canvasInfo.eyeInPlate), d, canvasInfo.projection);
            if (canvasInfo.useStereo) {
                if (canvasInfo.rightProjection == null) {
                    canvasInfo.rightProjection = new Transform3D();
                }
                this.computeProjection(canvasInfo, canvasInfo.rightEyeInPlate, this.getFrontClip(canvasInfo, canvasInfo.rightEyeInPlate), d, canvasInfo.rightProjection);
            }
            canvasInfo.updateProjection = false;
        }
    }

    public void getInverseProjection(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getInverseProjection", true);
        this.getInverseProjection(canvasInfo);
        transform3D.set(canvasInfo.inverseProjection);
        if (canvasInfo.useStereo && transform3D2 != null) {
            transform3D2.set(canvasInfo.inverseRightProjection);
        }
    }

    private void getInverseProjection(CanvasInfo canvasInfo) {
        if (canvasInfo.updateInverseProjection) {
            if (canvasInfo.inverseProjection == null) {
                canvasInfo.inverseProjection = new Transform3D();
            }
            this.getProjection(canvasInfo);
            canvasInfo.inverseProjection.invert(canvasInfo.projection);
            if (canvasInfo.useStereo) {
                if (canvasInfo.inverseRightProjection == null) {
                    canvasInfo.inverseRightProjection = new Transform3D();
                }
                canvasInfo.inverseRightProjection.invert(canvasInfo.rightProjection);
            }
            canvasInfo.updateInverseProjection = false;
        }
    }

    public void getInverseViewPlatformProjection(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getInverseViewPlatformProjection", true);
        this.getInverseViewPlatformProjection(canvasInfo);
        transform3D.set(canvasInfo.inverseViewPlatformProjection);
        if (canvasInfo.useStereo & transform3D2 != null) {
            transform3D2.set(canvasInfo.inverseViewPlatformRightProjection);
        }
    }

    private void getInverseViewPlatformProjection(CanvasInfo canvasInfo) {
        if (canvasInfo.updateInverseViewPlatformProjection) {
            if (canvasInfo.inverseViewPlatformProjection == null) {
                canvasInfo.inverseViewPlatformProjection = new Transform3D();
            }
            this.getInverseProjection(canvasInfo);
            this.getEyeToViewPlatform(canvasInfo);
            canvasInfo.inverseViewPlatformProjection.mul(canvasInfo.eyeToViewPlatform, canvasInfo.inverseProjection);
            if (canvasInfo.useStereo) {
                if (canvasInfo.inverseViewPlatformRightProjection == null) {
                    canvasInfo.inverseViewPlatformRightProjection = new Transform3D();
                }
                canvasInfo.inverseViewPlatformRightProjection.mul(canvasInfo.rightEyeToViewPlatform, canvasInfo.inverseRightProjection);
            }
            canvasInfo.updateInverseVworldProjection = false;
        }
    }

    public void getInverseVworldProjection(Canvas3D canvas3D, Transform3D transform3D, Transform3D transform3D2) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getInverseVworldProjection", true);
        this.getInverseVworldProjection(canvasInfo);
        transform3D.set(canvasInfo.inverseVworldProjection);
        if (canvasInfo.useStereo & transform3D2 != null) {
            transform3D2.set(canvasInfo.inverseVworldRightProjection);
        }
    }

    private void getInverseVworldProjection(CanvasInfo canvasInfo) {
        if (canvasInfo.updateInverseVworldProjection) {
            if (canvasInfo.inverseVworldProjection == null) {
                canvasInfo.inverseVworldProjection = new Transform3D();
            }
            this.getInverseViewPlatformProjection(canvasInfo);
            canvasInfo.inverseVworldProjection.mul(this.vpi.viewPlatformToVworld, canvasInfo.inverseViewPlatformProjection);
            if (canvasInfo.useStereo) {
                if (canvasInfo.inverseVworldRightProjection == null) {
                    canvasInfo.inverseVworldRightProjection = new Transform3D();
                }
                canvasInfo.inverseVworldRightProjection.mul(this.vpi.viewPlatformToVworld, canvasInfo.inverseViewPlatformRightProjection);
            }
            canvasInfo.updateInverseVworldProjection = false;
        }
    }

    private void computeProjection(CanvasInfo canvasInfo, Point3d point3d, double d, double d2, Transform3D transform3D) {
        double d3 = canvasInfo.canvasX - point3d.x;
        double d4 = canvasInfo.canvasY - point3d.y;
        double d5 = canvasInfo.canvasX + canvasInfo.canvasWidth - point3d.x;
        double d6 = canvasInfo.canvasY + canvasInfo.canvasHeight - point3d.y;
        double d7 = d - point3d.z;
        double d8 = d2 - point3d.z;
        double d9 = -point3d.z;
        if (this.projectionPolicy == 1) {
            this.computePerspectiveProjection(d3, d4, d5, d6, d9, d7, d8, this.m16d);
        } else {
            this.computeParallelProjection(d3, d4, d5, d6, d7, d8, this.m16d);
        }
        transform3D.set(this.m16d);
    }

    private void computePerspectiveProjection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double[] dArray) {
        double d8 = 1.0 / (d3 - d);
        double d9 = 1.0 / (d4 - d2);
        double d10 = 1.0 / (d6 - d7);
        dArray[0] = -2.0 * d5 * d8;
        dArray[5] = -2.0 * d5 * d9;
        dArray[2] = (d3 + d) * d8;
        dArray[6] = (d4 + d2) * d9;
        dArray[10] = -(d6 + d7) * d10;
        dArray[11] = 2.0 * d7 * d6 * d10;
        dArray[14] = -1.0;
        dArray[15] = 0.0;
        dArray[13] = 0.0;
        dArray[12] = 0.0;
        dArray[9] = 0.0;
        dArray[8] = 0.0;
        dArray[7] = 0.0;
        dArray[4] = 0.0;
        dArray[3] = 0.0;
        dArray[1] = 0.0;
    }

    private void computeParallelProjection(double d, double d2, double d3, double d4, double d5, double d6, double[] dArray) {
        double d7 = 1.0 / (d3 - d);
        double d8 = 1.0 / (d4 - d2);
        double d9 = 1.0 / (d5 - d6);
        dArray[0] = 2.0 * d7;
        dArray[5] = 2.0 * d8;
        dArray[10] = 2.0 * d9;
        dArray[3] = -(d3 + d) * d7;
        dArray[7] = -(d4 + d2) * d8;
        dArray[11] = -(d5 + d6) * d9;
        dArray[15] = 1.0;
        dArray[14] = 0.0;
        dArray[13] = 0.0;
        dArray[12] = 0.0;
        dArray[9] = 0.0;
        dArray[8] = 0.0;
        dArray[6] = 0.0;
        dArray[4] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
    }

    private double getFrontClip(CanvasInfo canvasInfo, Point3d point3d) {
        if (this.frontClipPolicy == 3 || this.frontClipPolicy == 2) {
            return point3d.z - canvasInfo.frontClipDistance;
        }
        return -canvasInfo.frontClipDistance;
    }

    private double getBackClip(CanvasInfo canvasInfo, Point3d point3d) {
        if (this.backClipPolicy == 3 || this.backClipPolicy == 2) {
            return point3d.z - canvasInfo.backClipDistance;
        }
        return -canvasInfo.backClipDistance;
    }

    private double getClipScale(CanvasInfo canvasInfo, int n) {
        if (n == 2 || n == 0) {
            this.getScreenScale(canvasInfo);
            if (this.resizePolicy == 1) {
                return this.vpi.vworldToViewPlatformScale * canvasInfo.screenScale * canvasInfo.windowScale;
            }
            return this.vpi.vworldToViewPlatformScale * canvasInfo.screenScale;
        }
        if (this.resizePolicy == 1) {
            return canvasInfo.windowScale;
        }
        return 1.0;
    }

    public double getPhysicalFrontClipDistance(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalFrontClipDistance", true);
        this.getClipDistances(canvasInfo);
        return canvasInfo.frontClipDistance;
    }

    public double getPhysicalBackClipDistance(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalBackClipDistance", true);
        this.getClipDistances(canvasInfo);
        return canvasInfo.backClipDistance;
    }

    private void getClipDistances(CanvasInfo canvasInfo) {
        if (canvasInfo.updateClipDistances) {
            canvasInfo.frontClipDistance = this.view.getFrontClipDistance() * this.getClipScale(canvasInfo, this.frontClipPolicy);
            canvasInfo.backClipDistance = this.view.getBackClipDistance() * this.getClipScale(canvasInfo, this.backClipPolicy);
            canvasInfo.updateClipDistances = false;
        }
    }

    private void getScreenScale(CanvasInfo canvasInfo) {
        if (canvasInfo.updateScreenScale) {
            if (this.scalePolicy == 0) {
                canvasInfo.screenScale = canvasInfo.si.screenWidth / 2.0;
            } else {
                canvasInfo.screenScale = this.view.getScreenScale();
            }
            canvasInfo.updateScreenScale = false;
        }
    }

    public double getPhysicalToViewPlatformScale(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalToViewPlatformScale", false);
        this.getPhysicalToViewPlatformScale(canvasInfo);
        return canvasInfo.physicalToVpScale;
    }

    private void getPhysicalToViewPlatformScale(CanvasInfo canvasInfo) {
        if (canvasInfo.updatePhysicalToVpScale) {
            this.getScreenScale(canvasInfo);
            if (this.resizePolicy == 1) {
                canvasInfo.physicalToVpScale = 1.0 / (canvasInfo.screenScale * canvasInfo.windowScale);
            } else {
                canvasInfo.physicalToVpScale = 1.0 / canvasInfo.screenScale;
            }
            canvasInfo.updatePhysicalToVpScale = false;
        }
    }

    public double getPhysicalToVirtualScale(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalToVirtualScale", true);
        this.getPhysicalToVirtualScale(canvasInfo);
        return canvasInfo.physicalToVirtualScale;
    }

    private void getPhysicalToVirtualScale(CanvasInfo canvasInfo) {
        if (canvasInfo.updatePhysicalToVirtualScale) {
            this.getPhysicalToViewPlatformScale(canvasInfo);
            canvasInfo.physicalToVirtualScale = canvasInfo.physicalToVpScale / this.vpi.vworldToViewPlatformScale;
            canvasInfo.updatePhysicalToVirtualScale = false;
        }
    }

    public double getPhysicalWidth(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalWidth", false);
        return canvasInfo.canvasWidth;
    }

    public double getPhysicalHeight(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalHeight", false);
        return canvasInfo.canvasHeight;
    }

    public void getPhysicalLocation(Canvas3D canvas3D, Point3d point3d) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPhysicalLocation", false);
        point3d.set(canvasInfo.canvasX, canvasInfo.canvasY, 0.0);
    }

    public void getPixelLocationInImagePlate(Canvas3D canvas3D, int n, int n2, Point3d point3d) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getPixelLocationInImagePlate", false);
        point3d.set(canvasInfo.canvasX + (double)n * canvasInfo.si.metersPerPixelX, canvasInfo.canvasY - (double)n2 * canvasInfo.si.metersPerPixelY + canvasInfo.canvasHeight, 0.0);
    }

    public void getSensorToVworld(Canvas3D canvas3D, Sensor sensor, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getSensorToVworld", true);
        this.getTrackerBaseToVworld(canvasInfo);
        sensor.getRead(transform3D);
        transform3D.mul(canvasInfo.trackerBaseToVworld, transform3D);
    }

    public void getTrackerBaseToViewPlatform(Canvas3D canvas3D, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getTrackerBaseToViewPlatform", false);
        this.getTrackerBaseToViewPlatform(canvasInfo);
        transform3D.set(canvasInfo.trackerBaseToViewPlatform);
    }

    private void getTrackerBaseToViewPlatform(CanvasInfo canvasInfo) {
        if (canvasInfo.updateTrackerBaseToViewPlatform) {
            if (canvasInfo.trackerBaseToViewPlatform == null) {
                canvasInfo.trackerBaseToViewPlatform = new Transform3D();
            }
            this.getViewPlatformToCoexistence(canvasInfo);
            canvasInfo.trackerBaseToViewPlatform.mul(this.coeToTrackerBase, canvasInfo.viewPlatformToCoe);
            canvasInfo.trackerBaseToViewPlatform.invert();
            canvasInfo.updateTrackerBaseToViewPlatform = false;
        }
    }

    public void getTrackerBaseToVworld(Canvas3D canvas3D, Transform3D transform3D) {
        CanvasInfo canvasInfo = this.updateCache(canvas3D, "getTrackerBaseToVworld", true);
        this.getTrackerBaseToVworld(canvasInfo);
        transform3D.set(canvasInfo.trackerBaseToVworld);
    }

    private void getTrackerBaseToVworld(CanvasInfo canvasInfo) {
        if (canvasInfo.updateTrackerBaseToVworld) {
            if (canvasInfo.trackerBaseToVworld == null) {
                canvasInfo.trackerBaseToVworld = new Transform3D();
            }
            this.getTrackerBaseToViewPlatform(canvasInfo);
            canvasInfo.trackerBaseToVworld.mul(this.vpi.viewPlatformToVworld, canvasInfo.trackerBaseToViewPlatform);
            canvasInfo.updateTrackerBaseToVworld = false;
        }
    }

    public static synchronized void clear() {
        Iterator iterator = staticVpMap.values().iterator();
        while (iterator.hasNext()) {
            ((ViewPlatformInfo)iterator.next()).clear();
        }
        staticVpMap.clear();
        iterator = staticSiMap.values().iterator();
        while (iterator.hasNext()) {
            ((ScreenInfo)iterator.next()).clear();
        }
        staticSiMap.clear();
    }

    public void updateScreen(Screen3D screen3D) {
        ScreenInfo screenInfo = (ScreenInfo)this.screenMap.get(screen3D);
        if (screenInfo != null) {
            screenInfo.updateScreen = true;
        }
    }

    public void updateCanvas(Canvas3D canvas3D) {
        CanvasInfo canvasInfo = (CanvasInfo)this.canvasMap.get(canvas3D);
        if (canvasInfo != null) {
            canvasInfo.updateCanvas = true;
        }
    }

    public void updateView() {
        this.updateView = true;
    }

    public void updateHead() {
        this.updateHead = true;
    }

    public void updateViewPlatform() {
        this.vpi.updateViewPlatformToVworld = true;
    }

    private void getAutoUpdate(CanvasInfo canvasInfo) {
        if ((this.autoUpdateFlags & 1) != 0) {
            canvasInfo.si.updateScreen = true;
        }
        if ((this.autoUpdateFlags & 2) != 0) {
            canvasInfo.updateCanvas = true;
        }
        if ((this.autoUpdateFlags & 0x10) != 0) {
            this.vpi.updateViewPlatformToVworld = true;
        }
        if ((this.autoUpdateFlags & 8) != 0) {
            this.updateHead = true;
        }
    }

    private CanvasInfo updateCache(Canvas3D canvas3D, String string, boolean bl) {
        CanvasInfo canvasInfo;
        if (this.updateView || (this.autoUpdateFlags & 4) != 0) {
            this.getViewInfo();
        }
        if ((canvasInfo = (CanvasInfo)this.canvasMap.get(canvas3D)) == null) {
            throw new IllegalArgumentException("\nSpecified Canvas3D is not a component of the View");
        }
        if (this.autoUpdate) {
            this.getAutoUpdate(canvasInfo);
        }
        if (canvasInfo.si.updateScreen) {
            canvasInfo.si.getScreenInfo();
        }
        if (canvasInfo.updateCanvas) {
            canvasInfo.getCanvasInfo();
        }
        if (bl && this.vpi.updateViewPlatformToVworld) {
            this.vpi.getViewPlatformToVworld();
        }
        if (this.useTracking && this.updateHead) {
            this.getHeadInfo();
        }
        return canvasInfo;
    }

    private void getViewInfo() {
        int n;
        if (this.canvasCount != this.view.numCanvas3Ds()) {
            this.canvasCount = this.view.numCanvas3Ds();
            this.getCanvases();
        } else {
            n = 0;
            while (n < this.canvasCount) {
                if (this.canvasMap.get(this.view.getCanvas3D(n)) != this.canvasInfo[n]) {
                    this.getCanvases();
                    break;
                }
                ++n;
            }
        }
        this.getViewPlatform();
        this.body = this.view.getPhysicalBody();
        this.env = this.view.getPhysicalEnvironment();
        this.useTracking = this.useHeadTracking();
        if (this.view.getTrackingEnable() && this.env.getTrackingAvailable()) {
            n = this.env.getHeadIndex();
            this.headTracker = this.env.getSensor(n);
        }
        this.viewPolicy = this.view.getViewPolicy();
        this.projectionPolicy = this.view.getProjectionPolicy();
        this.resizePolicy = this.view.getWindowResizePolicy();
        this.movementPolicy = this.view.getWindowMovementPolicy();
        this.eyePolicy = this.view.getWindowEyepointPolicy();
        this.scalePolicy = this.view.getScreenScalePolicy();
        this.backClipPolicy = this.view.getBackClipPolicy();
        this.frontClipPolicy = this.view.getFrontClipPolicy();
        if (this.useTracking || this.viewPolicy == 1) {
            if (this.headToHeadTracker == null) {
                this.headToHeadTracker = new Transform3D();
            }
            if (this.headTrackerToTrackerBase == null) {
                this.headTrackerToTrackerBase = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                if (this.trackerBaseToHeadTracker == null) {
                    this.trackerBaseToHeadTracker = new Transform3D();
                }
                if (this.coeToHeadTracker == null) {
                    this.coeToHeadTracker = new Transform3D();
                }
            } else if (this.headToTrackerBase == null) {
                this.headToTrackerBase = new Transform3D();
            }
            this.body.getLeftEyePosition(this.leftEyeInHead);
            this.body.getRightEyePosition(this.rightEyeInHead);
            this.body.getHeadToHeadTracker(this.headToHeadTracker);
        }
        if (this.eyePolicy == 1 || this.eyePolicy == 2) {
            this.body.getLeftEyePosition(this.leftEyeInHead);
            this.body.getRightEyePosition(this.rightEyeInHead);
        }
        this.coeCentering = this.env.getCoexistenceCenterInPworldPolicy() != 2 || this.viewPolicy == 1 ? false : this.view.getCoexistenceCenteringEnable();
        if (!this.coeCentering || this.useTracking) {
            if (this.coeToTrackerBase == null) {
                this.coeToTrackerBase = new Transform3D();
            }
            this.env.getCoexistenceToTrackerBase(this.coeToTrackerBase);
        }
        this.clipVirtual = this.backClipPolicy == 2 || this.backClipPolicy == 0 || this.frontClipPolicy == 2 || this.frontClipPolicy == 0;
        n = 0;
        while (n < this.canvasCount) {
            this.canvasInfo[n].updateViewDependencies();
            ++n;
        }
        this.updateView = false;
    }

    private void getCanvases() {
        Object object;
        if (this.canvasInfo.length < this.canvasCount) {
            this.canvasInfo = new CanvasInfo[this.canvasCount];
        }
        int n = 0;
        while (n < this.canvasCount) {
            CanvasInfo canvasInfo;
            Canvas3D canvas3D = this.view.getCanvas3D(n);
            object = canvas3D.getScreen3D();
            ScreenInfo screenInfo = (ScreenInfo)this.screenMap.get(object);
            if (screenInfo == null) {
                screenInfo = new ScreenInfo((Screen3D)object, canvas3D.getGraphicsConfiguration());
                this.screenMap.put(object, screenInfo);
            }
            if (this.newSet.add(screenInfo)) {
                screenInfo.clear(this);
            }
            if ((canvasInfo = (CanvasInfo)this.canvasMap.get(canvas3D)) == null) {
                canvasInfo = new CanvasInfo(canvas3D, screenInfo);
            }
            screenInfo.addCanvasInfo(this, canvasInfo);
            this.newMap.put(canvas3D, canvasInfo);
            this.canvasInfo[n] = canvasInfo;
            ++n;
        }
        int n2 = this.canvasCount;
        while (n2 < this.canvasInfo.length) {
            this.canvasInfo[n2] = null;
            ++n2;
        }
        object = this.canvasMap;
        this.canvasMap = this.newMap;
        this.newMap = object;
        this.newMap.clear();
        this.newSet.clear();
    }

    private void clearCanvases() {
        this.canvasCount = 0;
        this.canvasMap.clear();
        this.updateView = true;
    }

    private void getViewPlatform() {
        ViewPlatform viewPlatform = this.view.getViewPlatform();
        if (viewPlatform == null) {
            throw new IllegalStateException("The View must be attached to a ViewPlatform");
        }
        ViewPlatformInfo viewPlatformInfo = (ViewPlatformInfo)this.viewPlatformMap.get(viewPlatform);
        if (viewPlatformInfo == null) {
            viewPlatformInfo = new ViewPlatformInfo(viewPlatform);
            this.viewPlatformMap.put(viewPlatform, viewPlatformInfo);
        }
        if (this.vpi != viewPlatformInfo) {
            if (this.vpi != null) {
                this.vpi.removeViewInfo(this);
            }
            this.vpi = viewPlatformInfo;
            this.vpi.addViewInfo(this);
            if (viewPlatform.getCapability(11)) {
                this.vpi.updateViewPlatformToVworld = true;
            }
        }
    }

    private void clearViewPlatform() {
        this.updateView = true;
    }

    private void updateVworldDependencies() {
        int n = 0;
        while (n < this.canvasCount) {
            this.canvasInfo[n].updateVworldDependencies();
            ++n;
        }
    }

    protected Transform3D getHeadTrackerToTrackerBase() {
        this.headTracker.getRead(this.headTrackerToTrackerBase);
        return this.headTrackerToTrackerBase;
    }

    protected boolean useHeadTracking() {
        return this.view.getTrackingEnable() && this.env.getTrackingAvailable();
    }

    private void getHeadInfo() {
        this.headTrackerToTrackerBase = this.getHeadTrackerToTrackerBase();
        if (this.viewPolicy == 1) {
            this.trackerBaseToHeadTracker.invert(this.headTrackerToTrackerBase);
            this.coeToHeadTracker.mul(this.trackerBaseToHeadTracker, this.coeToTrackerBase);
        } else {
            this.headToTrackerBase.mul(this.headTrackerToTrackerBase, this.headToHeadTracker);
        }
        int n = 0;
        while (n < this.canvasCount) {
            this.canvasInfo[n].updateHeadDependencies();
            ++n;
        }
        this.updateHead = false;
    }

    private static void t3dPrint(Transform3D transform3D, String string) {
        double[] dArray = new double[16];
        transform3D.get(dArray);
        String[] stringArray = ViewInfo.formatMatrixRows(4, 4, dArray);
        System.err.println(string);
        int n = 0;
        while (n < 4) {
            System.err.println(stringArray[n]);
            ++n;
        }
    }

    private static String[] formatMatrixRows(int n, int n2, double[] dArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.setLength(0);
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer2.setLength(0);
                decimalFormat.format(dArray[n3 * n2 + n4], stringBuffer2, fieldPosition);
                int n5 = 8 - fieldPosition.getEndIndex();
                int n6 = 0;
                while (n6 < n5) {
                    stringBuffer2.insert(0, " ");
                    ++n6;
                }
                stringBuffer.append(stringBuffer2);
                ++n4;
            }
            stringArray[n3] = stringBuffer.toString();
            ++n3;
        }
        return stringArray;
    }

    private class CanvasInfo {
        private Canvas3D c3d = null;
        private ScreenInfo si = null;
        private boolean updateCanvas = true;
        private double canvasX = 0.0;
        private double canvasY = 0.0;
        private boolean updatePosition = true;
        private double canvasWidth = 0.0;
        private double canvasHeight = 0.0;
        private double windowScale = 0.0;
        private boolean updateWindowScale = true;
        private double screenScale = 0.0;
        private boolean updateScreenScale = true;
        private boolean useStereo = false;
        private boolean updateStereo = true;
        private Transform3D coeToPlate = null;
        private Transform3D coeToRightPlate = null;
        private boolean updateCoeToPlate = true;
        private Transform3D viewPlatformToCoe = null;
        private Transform3D coeToViewPlatform = null;
        private boolean updateViewPlatformToCoe = true;
        private boolean updateCoeToViewPlatform = true;
        private Transform3D plateToViewPlatform = null;
        private Transform3D rightPlateToViewPlatform = null;
        private boolean updatePlateToViewPlatform = true;
        private Transform3D trackerBaseToViewPlatform = null;
        private boolean updateTrackerBaseToViewPlatform = true;
        private Point3d eyeInPlate = new Point3d();
        private Point3d rightEyeInPlate = new Point3d();
        private Transform3D eyeToPlate = null;
        private Transform3D rightEyeToPlate = null;
        private boolean updateEyeInPlate = true;
        private Point3d leftManualEyeInPlate = new Point3d();
        private Point3d rightManualEyeInPlate = new Point3d();
        private boolean updateManualEye = true;
        private int monoscopicPolicy = -1;
        private boolean updateMonoPolicy = true;
        private Transform3D eyeToViewPlatform = null;
        private Transform3D rightEyeToViewPlatform = null;
        private boolean updateEyeToViewPlatform = true;
        private Transform3D viewPlatformToEye = null;
        private Transform3D viewPlatformToRightEye = null;
        private boolean updateViewPlatformToEye = true;
        private Transform3D projection = null;
        private Transform3D rightProjection = null;
        private boolean updateProjection = true;
        private Transform3D inverseProjection = null;
        private Transform3D inverseRightProjection = null;
        private boolean updateInverseProjection = true;
        private Transform3D inverseViewPlatformProjection = null;
        private Transform3D inverseViewPlatformRightProjection = null;
        private boolean updateInverseViewPlatformProjection = true;
        private double frontClipDistance = 0.0;
        private double backClipDistance = 0.0;
        private boolean updateClipDistances = true;
        private double physicalToVpScale = 0.0;
        private double physicalToVirtualScale = 0.0;
        private boolean updatePhysicalToVpScale = true;
        private boolean updatePhysicalToVirtualScale = true;
        private Transform3D plateToVworld = null;
        private Transform3D rightPlateToVworld = null;
        private boolean updatePlateToVworld = true;
        private Transform3D coeToVworld = null;
        private boolean updateCoeToVworld = true;
        private Transform3D eyeToVworld = null;
        private Transform3D rightEyeToVworld = null;
        private boolean updateEyeToVworld = true;
        private Transform3D trackerBaseToVworld = null;
        private boolean updateTrackerBaseToVworld = true;
        private Transform3D inverseVworldProjection = null;
        private Transform3D inverseVworldRightProjection = null;
        private boolean updateInverseVworldProjection = true;

        private CanvasInfo(Canvas3D canvas3D, ScreenInfo screenInfo) {
            this.si = screenInfo;
            this.c3d = canvas3D;
        }

        private void getCanvasInfo() {
            int n;
            boolean bl;
            boolean bl2 = bl = this.c3d.getStereoEnable() && this.c3d.getStereoAvailable();
            if (this.useStereo != bl) {
                this.useStereo = bl;
                this.updateStereo = true;
            }
            this.canvasWidth = (double)this.c3d.getWidth() * this.si.metersPerPixelX;
            this.canvasHeight = (double)this.c3d.getHeight() * this.si.metersPerPixelY;
            double d = this.canvasWidth / this.si.screenWidth;
            if (this.windowScale != d) {
                this.windowScale = d;
                this.updateWindowScale = true;
            }
            Point point = this.c3d.getLocationOnScreen();
            int n2 = point.x - ((ScreenInfo)this.si).screenBounds.x;
            int n3 = point.y - ((ScreenInfo)this.si).screenBounds.y;
            double d2 = this.si.metersPerPixelX * (double)n2;
            double d3 = this.si.metersPerPixelY * (double)(((ScreenInfo)this.si).screenBounds.height - (n3 + this.c3d.getHeight()));
            if (this.canvasX != d2 || this.canvasY != d3) {
                this.canvasX = d2;
                this.canvasY = d3;
                this.updatePosition = true;
            }
            if (this.monoscopicPolicy != (n = this.c3d.getMonoscopicViewPolicy())) {
                this.monoscopicPolicy = n;
                this.updateMonoPolicy = true;
            }
            this.c3d.getLeftManualEyeInImagePlate(ViewInfo.this.leftEye);
            this.c3d.getRightManualEyeInImagePlate(ViewInfo.this.rightEye);
            if (!ViewInfo.this.leftEye.equals((Tuple3d)this.leftManualEyeInPlate) || !ViewInfo.this.rightEye.equals((Tuple3d)this.rightManualEyeInPlate)) {
                this.leftManualEyeInPlate.set((Tuple3d)ViewInfo.this.leftEye);
                this.rightManualEyeInPlate.set((Tuple3d)ViewInfo.this.rightEye);
                this.updateManualEye = true;
            }
            this.updateCanvasDependencies();
            this.updateStereo = false;
            this.updateWindowScale = false;
            this.updatePosition = false;
            this.updateMonoPolicy = false;
            this.updateManualEye = false;
            this.updateCanvas = false;
        }

        private double getFieldOfViewOffset() {
            return 0.5 * this.canvasWidth / Math.tan(0.5 * ViewInfo.this.view.getFieldOfView());
        }

        private void updateScreenDependencies() {
            if (this.si.updatePixelSize || this.si.updateScreenSize) {
                if (ViewInfo.this.eyePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateEyeInPlate = true;
                }
                if (ViewInfo.this.resizePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateViewPlatformToCoe = true;
                }
                if (ViewInfo.this.resizePolicy == 1) {
                    this.updateClipDistances = true;
                    this.updatePhysicalToVpScale = true;
                    this.updatePhysicalToVirtualScale = true;
                }
                this.updateProjection = true;
            }
            if (this.si.updateScreenSize && ViewInfo.this.scalePolicy == 0) {
                this.updateScreenScale = true;
                this.updateClipDistances = true;
                this.updatePhysicalToVpScale = true;
                this.updatePhysicalToVirtualScale = true;
                this.updateViewPlatformToCoe = true;
            }
            if (ViewInfo.this.viewPolicy == 1) {
                if (this.si.updateHeadTrackerToPlate) {
                    this.updateEyeInPlate = true;
                    this.updateCoeToPlate = true;
                }
            } else if (ViewInfo.this.coeCentering) {
                if (ViewInfo.this.movementPolicy == 1) {
                    if (this.si.updatePixelSize || this.si.updateScreenSize) {
                        this.updateCoeToPlate = true;
                    }
                } else if (this.si.updateScreenSize) {
                    this.updateCoeToPlate = true;
                }
            } else if (this.si.updateTrackerBaseToPlate) {
                this.updateCoeToPlate = true;
            }
            if (this.updateCoeToPlate && ViewInfo.this.eyePolicy == 3) {
                this.updateEyeInPlate = true;
            }
            if (this.updateViewPlatformToCoe) {
                this.updateCoeToViewPlatform = true;
                this.updateCoeToVworld = true;
                this.updateTrackerBaseToViewPlatform = true;
                this.updateTrackerBaseToVworld = true;
            }
            if (this.updateCoeToPlate || this.updateViewPlatformToCoe) {
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
            }
            this.updateEyeDependencies();
        }

        private void updateEyeDependencies() {
            if (this.updateEyeInPlate) {
                this.updateEyeToVworld = true;
                this.updateProjection = true;
            }
            if (this.updateProjection) {
                this.updateInverseProjection = true;
                this.updateInverseViewPlatformProjection = true;
                this.updateInverseVworldProjection = true;
            }
            if (this.updateEyeInPlate || this.updatePlateToViewPlatform) {
                this.updateViewPlatformToEye = true;
                this.updateEyeToViewPlatform = true;
            }
        }

        private void updateCanvasDependencies() {
            if (this.updateStereo || this.updateMonoPolicy || this.updateManualEye && (ViewInfo.this.eyePolicy == 1 || ViewInfo.this.eyePolicy == 0)) {
                this.updateEyeInPlate = true;
            }
            if (this.updateWindowScale || this.updatePosition) {
                if (ViewInfo.this.coeCentering && ViewInfo.this.movementPolicy == 1) {
                    this.updateCoeToPlate = true;
                    if (ViewInfo.this.eyePolicy == 3) {
                        this.updateEyeInPlate = true;
                    }
                }
                if (ViewInfo.this.eyePolicy == 2 || ViewInfo.this.eyePolicy == 1) {
                    this.updateEyeInPlate = true;
                }
            }
            if (this.updateWindowScale) {
                if (ViewInfo.this.resizePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateViewPlatformToCoe = true;
                    this.updateCoeToViewPlatform = true;
                    this.updateCoeToVworld = true;
                    this.updateTrackerBaseToViewPlatform = true;
                    this.updateTrackerBaseToVworld = true;
                }
                if (ViewInfo.this.resizePolicy == 1) {
                    this.updateClipDistances = true;
                    this.updateProjection = true;
                    this.updatePhysicalToVpScale = true;
                    this.updatePhysicalToVirtualScale = true;
                }
            }
            if (this.updateViewPlatformToCoe || this.updateCoeToPlate) {
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
            }
            if (ViewInfo.this.coeCentering && !this.updateManualEye && !this.updateWindowScale && ViewInfo.this.movementPolicy == 1 && ViewInfo.this.eyePolicy != 0) {
                return;
            }
            this.updateEyeDependencies();
        }

        private void updateViewDependencies() {
            this.updateEyeInPlate = true;
            this.updateProjection = true;
            this.updateClipDistances = true;
            this.updatePhysicalToVpScale = true;
            this.updatePhysicalToVirtualScale = true;
            this.updateCoeToPlate = true;
            this.updateViewPlatformToCoe = true;
            this.updateCoeToViewPlatform = true;
            this.updateCoeToVworld = true;
            this.updatePlateToViewPlatform = true;
            this.updatePlateToVworld = true;
            this.updateTrackerBaseToViewPlatform = true;
            this.updateTrackerBaseToVworld = true;
            this.updateScreenScale = true;
            this.updateEyeDependencies();
        }

        private void updateHeadDependencies() {
            if (ViewInfo.this.viewPolicy == 1) {
                this.updateCoeToPlate = true;
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
                this.updateViewPlatformToEye = true;
                this.updateEyeToViewPlatform = true;
                this.updateEyeToVworld = true;
                this.updateInverseViewPlatformProjection = true;
                this.updateInverseVworldProjection = true;
            } else {
                this.updateEyeInPlate = true;
                this.updateEyeDependencies();
            }
        }

        private void updateVworldDependencies() {
            this.updatePlateToVworld = true;
            this.updateCoeToVworld = true;
            this.updateEyeToVworld = true;
            this.updateTrackerBaseToVworld = true;
            this.updateInverseVworldProjection = true;
            if (ViewInfo.this.vpi.updateVworldScale) {
                this.updatePhysicalToVirtualScale = true;
            }
            if (ViewInfo.this.vpi.updateVworldScale && ViewInfo.this.clipVirtual) {
                this.updateProjection = true;
                this.updateClipDistances = true;
                this.updateInverseProjection = true;
                this.updateInverseViewPlatformProjection = true;
            }
        }
    }

    private static class ViewPlatformInfo {
        private ViewPlatform vp = null;
        private List viewInfo = new LinkedList();
        private double[] m = new double[16];
        private Transform3D viewPlatformToVworld = new Transform3D();
        private Transform3D vworldToViewPlatform = new Transform3D();
        private double vworldToViewPlatformScale = 1.0;
        private boolean updateViewPlatformToVworld = false;
        private boolean updateVworldScale = false;

        private ViewPlatformInfo(ViewPlatform viewPlatform) {
            this.vp = viewPlatform;
        }

        private synchronized void addViewInfo(ViewInfo viewInfo) {
            this.viewInfo.add(viewInfo);
        }

        private synchronized void removeViewInfo(ViewInfo viewInfo) {
            this.viewInfo.remove(viewInfo);
        }

        private synchronized void clear() {
            Iterator iterator = this.viewInfo.iterator();
            while (iterator.hasNext()) {
                ((ViewInfo)iterator.next()).clearViewPlatform();
            }
            this.viewInfo.clear();
        }

        private synchronized void getViewPlatformToVworld() {
            this.vp.getLocalToVworld(this.viewPlatformToVworld);
            this.vworldToViewPlatform.invert(this.viewPlatformToVworld);
            this.vworldToViewPlatform.get(this.m);
            double d = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2]);
            if (d > this.vworldToViewPlatformScale + 1.0E-7 || d < this.vworldToViewPlatformScale - 1.0E-7) {
                this.vworldToViewPlatformScale = d;
                this.updateVworldScale = true;
            }
            Iterator iterator = this.viewInfo.iterator();
            while (iterator.hasNext()) {
                ((ViewInfo)iterator.next()).updateVworldDependencies();
            }
            this.updateVworldScale = false;
            this.updateViewPlatformToVworld = false;
        }
    }

    private static class ScreenInfo {
        private Screen3D s3d = null;
        private GraphicsConfiguration graphicsConfiguration = null;
        private boolean updateScreen = true;
        private Map viewInfoMap = new HashMap();
        private List viewInfoList = new LinkedList();
        private Transform3D t3d = new Transform3D();
        private double screenWidth = 0.0;
        private double screenHeight = 0.0;
        private boolean updateScreenSize = true;
        private Rectangle screenBounds = null;
        private double metersPerPixelX = 0.0;
        private double metersPerPixelY = 0.0;
        private boolean updatePixelSize = true;
        private Transform3D trackerBaseToPlate = new Transform3D();
        private Transform3D headTrackerToLeftPlate = new Transform3D();
        private Transform3D headTrackerToRightPlate = new Transform3D();
        private boolean updateTrackerBaseToPlate = false;
        private boolean updateHeadTrackerToPlate = false;

        private ScreenInfo(Screen3D screen3D, GraphicsConfiguration graphicsConfiguration) {
            this.s3d = screen3D;
            this.graphicsConfiguration = graphicsConfiguration;
        }

        private List getCanvasList(ViewInfo viewInfo) {
            LinkedList linkedList = (LinkedList)this.viewInfoMap.get(viewInfo);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.viewInfoMap.put(viewInfo, linkedList);
                this.viewInfoList.add(linkedList);
            }
            return linkedList;
        }

        private synchronized void clear(ViewInfo viewInfo) {
            this.getCanvasList(viewInfo).clear();
        }

        private synchronized void clear() {
            Iterator<Object> iterator = this.viewInfoMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((ViewInfo)iterator.next()).clearCanvases();
            }
            this.viewInfoMap.clear();
            iterator = this.viewInfoList.iterator();
            while (iterator.hasNext()) {
                ((List)iterator.next()).clear();
            }
            this.viewInfoList.clear();
        }

        private synchronized void addCanvasInfo(ViewInfo viewInfo, CanvasInfo canvasInfo) {
            this.getCanvasList(viewInfo).add(canvasInfo);
        }

        private synchronized void getScreenInfo() {
            this.s3d.getTrackerBaseToImagePlate(this.t3d);
            if (!this.t3d.equals(this.trackerBaseToPlate)) {
                this.trackerBaseToPlate.set(this.t3d);
                this.updateTrackerBaseToPlate = true;
            }
            this.s3d.getHeadTrackerToLeftImagePlate(this.t3d);
            if (!this.t3d.equals(this.headTrackerToLeftPlate)) {
                this.headTrackerToLeftPlate.set(this.t3d);
                this.updateHeadTrackerToPlate = true;
            }
            this.s3d.getHeadTrackerToRightImagePlate(this.t3d);
            if (!this.t3d.equals(this.headTrackerToRightPlate)) {
                this.headTrackerToRightPlate.set(this.t3d);
                this.updateHeadTrackerToPlate = true;
            }
            double d = this.s3d.getPhysicalScreenWidth();
            double d2 = this.s3d.getPhysicalScreenHeight();
            if (d != this.screenWidth || d2 != this.screenHeight) {
                this.screenWidth = d;
                this.screenHeight = d2;
                this.updateScreenSize = true;
            }
            this.screenBounds = this.graphicsConfiguration.getBounds();
            double d3 = this.screenWidth / (double)this.screenBounds.width;
            double d4 = this.screenHeight / (double)this.screenBounds.height;
            if (d3 != this.metersPerPixelX || d4 != this.metersPerPixelY) {
                this.metersPerPixelX = d3;
                this.metersPerPixelY = d4;
                this.updatePixelSize = true;
            }
            Iterator iterator = this.viewInfoList.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    ((CanvasInfo)iterator2.next()).updateScreenDependencies();
                }
            }
            this.updateTrackerBaseToPlate = false;
            this.updateHeadTrackerToPlate = false;
            this.updateScreenSize = false;
            this.updatePixelSize = false;
            this.updateScreen = false;
        }
    }
}

