/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import com.sun.naming.internal.ResourceManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;

public class InitialEventContext
implements EventContext {
    protected Hashtable myProps = null;
    protected EventContext defaultInitCtx = null;
    protected boolean gotDefault = false;

    protected InitialEventContext(boolean lazy) throws NamingException {
        if (!lazy) {
            this.init(null);
        }
    }

    public InitialEventContext() throws NamingException {
        this.init(null);
    }

    public InitialEventContext(Hashtable environment) throws NamingException {
        if (environment != null) {
            this.init((Hashtable)environment.clone());
        } else {
            this.init(environment);
        }
    }

    protected void init(Hashtable environment) throws NamingException {
        this.myProps = ResourceManager.getInitialEnvironment(environment);
        if (this.myProps.get("java.naming.factory.initial") != null) {
            this.getDefaultInitCtx();
        }
    }

    private static String getURLScheme(String str) {
        int colonPosn = str.indexOf(58);
        int slashPosn = str.indexOf(47);
        if (colonPosn > 0 && (slashPosn == -1 || colonPosn < slashPosn)) {
            return str.substring(0, colonPosn);
        }
        return null;
    }

    protected EventContext getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = (EventContext)NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        if (this.defaultInitCtx == null) {
            throw new NoInitialContextException();
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context ctx;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        String scheme = InitialEventContext.getURLScheme(name);
        if (scheme != null && (ctx = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return ctx;
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        Context ctx;
        String first;
        String scheme;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (name.size() > 0 && (scheme = InitialEventContext.getURLScheme(first = name.get(0))) != null && (ctx = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return ctx;
        }
        return this.getDefaultInitCtx();
    }

    public Object lookup(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    public void unbind(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("composeName " + name + ", " + prefix + " is not supported.");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("composeName " + name + ", " + prefix + " is not supported.");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myProps.put(propName, propVal);
        return this.getDefaultInitCtx().addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        this.myProps.remove(propName);
        return this.getDefaultInitCtx().removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    public void close() throws NamingException {
        this.myProps = null;
        if (this.defaultInitCtx != null) {
            this.defaultInitCtx.close();
            this.defaultInitCtx = null;
        }
        this.gotDefault = false;
    }

    public String getNameInNamespace() throws NamingException {
        return this.getDefaultInitCtx().getNameInNamespace();
    }

    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.getDefaultInitCtx().addNamingListener(target, scope, l);
    }

    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.getDefaultInitCtx().addNamingListener(target, scope, l);
    }

    public void removeNamingListener(NamingListener l) throws NamingException {
        this.getDefaultInitCtx().removeNamingListener(l);
    }

    public boolean targetMustExist() throws NamingException {
        return this.getDefaultInitCtx().targetMustExist();
    }
}

