/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class JVMContext
extends EventProducer
implements EventContext,
EventProducerInterface,
Serializable {
    public static final EventType NUMBER_CHANGED_EVENT = new EventType("Number changed");
    public static final EventType CHILD_ADDED_EVENT = new EventType("Child added");
    public static final EventType CHILD_REMOVED_EVENT = new EventType("Child removed");
    private static Properties syntax = new Properties();
    protected Context parent;
    private String atomicName;
    protected Map elements = Collections.synchronizedMap(new TreeMap());
    protected List eventListeners = Collections.synchronizedList(new ArrayList());
    protected NameParser parser = new MyParser(syntax);

    static {
        syntax.put("jndi.syntax.direction", "left_to_right");
        syntax.put("jndi.syntax.separator", "/");
        syntax.put("jndi.syntax.escape", "&");
        syntax.put("jndi.syntax.beginquote", "\"");
        syntax.put("jndi.syntax.ava", ",");
        syntax.put("jndi.syntax.typeval", "=");
    }

    public JVMContext() {
        this(null, "");
    }

    public JVMContext(Context parent, String atomicName) {
        this.parent = parent;
        this.atomicName = atomicName;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        JVMContext clone = new JVMContext();
        HashMap elements = new HashMap(this.elements);
        Iterator i = elements.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = elements.get(key);
            if (value instanceof JVMContext) {
                JVMContext item = (JVMContext)value;
                value = item.clone();
            }
            elements.put(key, value);
        }
        clone.elements = elements;
        return clone;
    }

    private boolean isRootForwardable(Name name) throws NamingException {
        return this.parent != null && name.startsWith(this.parser.parse(syntax.getProperty("jndi.syntax.separator")));
    }

    private Context getRoot() throws NamingException {
        return (Context)this.lookup("");
    }

    private Name makeRelative(Name name) throws NamingException {
        if (name.startsWith(this.parser.parse(syntax.getProperty("jndi.syntax.separator")))) {
            return name.getSuffix(1);
        }
        return name;
    }

    public synchronized Object lookup(Name name) throws NamingException {
        if (this.isRootForwardable(name)) {
            return this.getRoot().lookup(name);
        }
        if (name.size() == 0 && this.parent == null) {
            return this;
        }
        if (name.size() == 0) {
            return this.parent.lookup(name);
        }
        Name relativeName = this.makeRelative(name);
        if (relativeName.size() > 1) {
            return ((Context)this.lookup(relativeName.get(0))).lookup(relativeName.getSuffix(1));
        }
        if (!this.elements.containsKey(relativeName.toString())) {
            throw new NamingException(relativeName + " not found.");
        }
        return this.elements.get(relativeName.toString());
    }

    public Object lookup(String arg0) throws NamingException {
        return this.lookup(this.parser.parse(arg0));
    }

    public synchronized void bind(Name name, Object value) throws NamingException {
        if (this.isRootForwardable(name)) {
            this.getRoot().bind(name, value);
            return;
        }
        Name relativeName = this.makeRelative(name);
        if (relativeName.size() > 1) {
            ((Context)this.lookup(relativeName.get(0))).bind(relativeName.getSuffix(1), value);
        } else {
            this.elements.put(relativeName.get(0), value);
            this.fireEvent((EventInterface)new Event(NUMBER_CHANGED_EVENT, (Object)this, (Object)new Integer(this.elements.size())));
            this.fireEvent((EventInterface)new Event(CHILD_ADDED_EVENT, (Object)this, value));
            this.fireContextEvent(true, String.valueOf(this.getNameInNamespace()) + syntax.getProperty("jndi.syntax.separator") + relativeName, value);
        }
    }

    public void bind(String name, Object value) throws NamingException {
        this.bind(this.parser.parse(name), value);
    }

    public void rebind(Name name, Object value) throws NamingException {
        this.bind(name, value);
    }

    public void rebind(String name, Object value) throws NamingException {
        this.bind(name, value);
    }

    public synchronized void unbind(Name name) throws NamingException {
        if (this.isRootForwardable(name)) {
            this.getRoot().unbind(name);
            return;
        }
        Name relativeName = this.makeRelative(name);
        if (relativeName.size() > 1) {
            ((Context)this.lookup(relativeName.get(0))).unbind(relativeName.getSuffix(1));
        } else {
            Object old = this.elements.get(relativeName.get(0));
            this.elements.remove(relativeName.get(0));
            this.fireEvent((EventInterface)new Event(NUMBER_CHANGED_EVENT, (Object)this, (Object)new Integer(this.elements.size())));
            this.fireEvent((EventInterface)new Event(CHILD_REMOVED_EVENT, (Object)this, old));
            this.fireContextEvent(false, String.valueOf(this.getNameInNamespace()) + syntax.getProperty("jndi.syntax.separator") + relativeName, old);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.parser.parse(name));
    }

    public void rename(Name nameOld, Name nameNew) throws NamingException {
        this.rename(nameOld.toString(), nameNew.toString());
    }

    public synchronized void rename(String nameOld, String nameNew) throws NamingException {
        if (!this.elements.containsKey(nameOld)) {
            throw new NamingException("Old name not found. Rename operation canceled.");
        }
        Object value = this.elements.get(nameOld);
        this.elements.remove(nameOld);
        this.elements.put(nameNew, value);
    }

    public NamingEnumeration list(Name name) {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) {
        if (name == null) {
            Logger.info((Object)this, (String)"list", (String)"name==null");
        }
        return new NamingList(true);
    }

    public NamingEnumeration listBindings(Name name) {
        if (name == null) {
            Logger.info((Object)this, (String)"listBindings", (String)"name==null");
        }
        return new NamingList(false);
    }

    public NamingEnumeration listBindings(String name) {
        if (name == null) {
            Logger.info((Object)this, (String)"listBindings", (String)"name==null");
        }
        return new NamingList(false);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.unbind(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    public synchronized Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            String subName = name.get(0);
            JVMContext newContext = new JVMContext(this, subName);
            this.bind(subName, (Object)newContext);
            return newContext;
        }
        Context c = (Context)this.lookup(name.get(0));
        return c.createSubcontext(name.getSuffix(1));
    }

    public Context createSubcontext(String arg0) throws NamingException {
        return this.createSubcontext(this.parser.parse(arg0));
    }

    public Object lookupLink(Name name) {
        return this.elements.get(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(Name name) {
        if (name == null) {
            Logger.info((Object)this, (String)"getNameParser", (String)"name==null");
        }
        return this.parser;
    }

    public NameParser getNameParser(String name) {
        if (name == null) {
            Logger.info((Object)this, (String)"getNameParser", (String)"name==null");
        }
        return this.parser;
    }

    public Name composeName(Name arg0, Name arg1) throws NamingException {
        throw new NamingException("composeName " + arg0 + ", " + arg1 + " is not supported.");
    }

    public String composeName(String arg0, String arg1) throws NamingException {
        throw new NamingException("composeName " + arg0 + ", " + arg1 + " is not supported.");
    }

    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        throw new NamingException("addToEnvironment " + arg0 + ", " + arg1 + " is not supported.");
    }

    public Object removeFromEnvironment(String arg0) throws NamingException {
        throw new NamingException("removeFromEnvironment " + arg0 + " is not supported.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new NamingException("Not supported.");
    }

    public void close() {
    }

    public synchronized String getNameInNamespace() throws NamingException {
        if (this.parent != null) {
            return String.valueOf(this.parent.getNameInNamespace()) + syntax.get("jndi.syntax.separator") + this.atomicName;
        }
        return this.atomicName;
    }

    public void addNamingListener(Name target, int scope, NamingListener l) {
        this.eventListeners.add(new EventContextListenerRecord(target, scope, l));
    }

    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(this.parser.parse(target), scope, l);
    }

    public synchronized void removeNamingListener(NamingListener l) {
        EventContextListenerRecord removable = null;
        Iterator i = this.eventListeners.iterator();
        while (i.hasNext()) {
            EventContextListenerRecord current = (EventContextListenerRecord)i.next();
            if (!current.getListener().equals(l)) continue;
            removable = current;
            break;
        }
        if (removable != null) {
            this.eventListeners.remove(removable);
        }
    }

    public boolean targetMustExist() {
        return false;
    }

    private void fireContextEvent(boolean isAddition, String name, Object value) throws NamingException {
        this.fireContextEvent(isAddition, this.parser.parse(name), value);
    }

    private synchronized void fireContextEvent(boolean isAddition, Name name, Object value) {
        Iterator i = this.eventListeners.iterator();
        while (i.hasNext()) {
            EventContextListenerRecord record = (EventContextListenerRecord)i.next();
            int scope = record.getScope();
            NamingEvent namingEvent = null;
            namingEvent = isAddition ? new NamingEvent(this, 0, new Binding(name.toString(), value), null, null) : new NamingEvent(this, 1, null, new Binding(name.toString(), value), null);
            if (name.equals(record.getTarget()) || scope == 2) {
                namingEvent.dispatch(record.getListener());
                continue;
            }
            if (scope != 1 || record.getTarget().size() != 1) continue;
            namingEvent.dispatch(record.getListener());
        }
    }

    public String toString() {
        try {
            return "JVMContext: " + this.getNameInNamespace() + " ";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    private class EventContextListenerRecord {
        private Name target;
        private int scope;
        private NamingListener listener;

        public EventContextListenerRecord(Name target, int scope, NamingListener listener) {
            this.target = target;
            this.scope = scope;
            this.listener = listener;
        }

        public NamingListener getListener() {
            return this.listener;
        }

        public int getScope() {
            return this.scope;
        }

        public Name getTarget() {
            return this.target;
        }
    }

    private class NamingList
    extends ArrayList
    implements NamingEnumeration {
        private Iterator myIterator = null;

        public NamingList(boolean classList) {
            Set keys = JVMContext.this.elements.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String currentKey = (String)i.next();
                if (classList) {
                    this.add(new NameClassPair(currentKey, JVMContext.this.elements.get(currentKey).getClass().toString()));
                    continue;
                }
                this.add(new Binding(currentKey, JVMContext.this.elements.get(currentKey)));
            }
        }

        public void close() {
            this.myIterator = null;
        }

        public boolean hasMoreElements() {
            boolean hasNext;
            if (this.myIterator == null) {
                this.myIterator = this.iterator();
            }
            if (!(hasNext = this.myIterator.hasNext())) {
                this.myIterator = null;
                return false;
            }
            return true;
        }

        public Object nextElement() {
            if (this.myIterator == null) {
                this.myIterator = this.iterator();
            }
            return this.myIterator.next();
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }
    }

    private class MyParser
    implements NameParser,
    Serializable {
        private Properties syntax = null;

        public MyParser(Properties syntax) {
            this.syntax = syntax;
        }

        public Name parse(String name) throws NamingException {
            Name result = new CompoundName(name, this.syntax);
            if (result.size() > 0 && result.get(0).equals(".") && JVMContext.this.parent != null) {
                result = result.getSuffix(1);
            }
            return result;
        }
    }
}

