/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import nl.tudelft.simulation.naming.RemoteContextInterface;
import nl.tudelft.simulation.naming.listener.RemoteContextListenerClient;
import nl.tudelft.simulation.naming.listener.RemoteContextListenerInterface;

public class RemoteContext
extends UnicastRemoteObject
implements RemoteContextInterface {
    private EventContext eventContext = null;
    private Map listeners = Collections.synchronizedMap(new HashMap());

    public RemoteContext(EventContext eventContext) throws RemoteException {
        this.eventContext = eventContext;
    }

    public void addNamingListener(Name target, int scope, RemoteContextListenerInterface l) throws NamingException {
        RemoteContextListenerClient client = new RemoteContextListenerClient(l);
        this.listeners.put(l, client);
        this.eventContext.addNamingListener(target, scope, (NamingListener)client);
    }

    public void addNamingListener(String target, int scope, RemoteContextListenerInterface l) throws NamingException {
        RemoteContextListenerClient client = new RemoteContextListenerClient(l);
        this.listeners.put(l, client);
        this.eventContext.addNamingListener(target, scope, (NamingListener)client);
    }

    public void removeNamingListener(RemoteContextListenerInterface l) throws NamingException {
        this.eventContext.removeNamingListener((NamingListener)this.listeners.remove(l));
    }

    public boolean targetMustExist() throws NamingException {
        return this.eventContext.targetMustExist();
    }

    public Object lookup(Name name) throws NamingException {
        return this.eventContext.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        return this.eventContext.lookup(name);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.eventContext.bind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.eventContext.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.eventContext.rebind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.eventContext.rebind(name, obj);
    }

    public void unbind(Name name) throws NamingException {
        this.eventContext.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this.eventContext.unbind(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.eventContext.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.eventContext.rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.eventContext.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.eventContext.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.eventContext.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.eventContext.listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.eventContext.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.eventContext.destroySubcontext(name);
    }

    public RemoteContextInterface createSubcontext(Name name) throws NamingException, RemoteException {
        EventContext child = (EventContext)this.eventContext.createSubcontext(name);
        return new RemoteContext(child);
    }

    public RemoteContextInterface createSubcontext(String name) throws NamingException, RemoteException {
        EventContext child = (EventContext)this.eventContext.createSubcontext(name);
        return new RemoteContext(child);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.eventContext.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.eventContext.lookupLink(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.eventContext.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.eventContext.getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.eventContext.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.eventContext.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.eventContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.eventContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.eventContext.getEnvironment();
    }

    public void close() throws NamingException {
        this.eventContext.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this.eventContext.getNameInNamespace();
    }
}

