/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations.reflection;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantMethodref;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.NEW;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class INVOKESPECIAL
extends InvokeOperation {
    public static final int OP = 183;
    protected int index = -1;
    private final Map CACHE = new HashMap();

    public INVOKESPECIAL(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame execute(Frame frame) {
        try {
            ConstantMethodref constantMethodref = (ConstantMethodref)frame.getConstantPool()[this.index];
            Class[] parameterTypes = new MethodSignature(constantMethodref.getConstantNameAndType().getDescriptor()).getParameterTypes();
            String methodName = constantMethodref.getConstantNameAndType().getName();
            if (methodName.equals("<init>")) {
                Object[] args = new Object[parameterTypes.length];
                for (int i = args.length - 1; i > -1; --i) {
                    args[i] = Primitive.cast(parameterTypes[i], frame.getOperandStack().pop());
                }
                Object objectRef = frame.getOperandStack().pop();
                Class instanceClass = ((NEW.UninitializedInstance)objectRef).getInstanceClass();
                Constructor constructor = ClassUtil.resolveConstructor(instanceClass, parameterTypes);
                ((AccessibleObject)constructor).setAccessible(true);
                Object result = constructor.newInstance(args);
                frame.getOperandStack().replace(objectRef, result);
                LocalVariable.replace(frame.getLocalVariables(), objectRef, result);
                return null;
            }
            Object objectRef = frame.getOperandStack().peek(parameterTypes.length);
            Method method = null;
            if (this.CACHE.containsKey(frame.getMethodDescriptor())) {
                method = (Method)this.CACHE.get(frame.getMethodDescriptor());
            } else {
                Class referenceClass = constantMethodref.getConstantClass().getValue().getClassValue();
                method = objectRef.getClass().getSuperclass().equals(referenceClass) ? ClassUtil.resolveMethod(objectRef.getClass().getSuperclass(), methodName, parameterTypes) : ClassUtil.resolveMethod(objectRef, methodName, parameterTypes);
                this.CACHE.put(frame.getMethodDescriptor(), method);
            }
            OperandStack operandStack = frame.getOperandStack();
            synchronized (operandStack) {
                Object[] args = new Object[parameterTypes.length];
                for (int i = args.length - 1; i > -1; --i) {
                    args[i] = Primitive.cast(parameterTypes[i], frame.getOperandStack().pop());
                }
                frame.getOperandStack().pop();
                return this.execute(frame, objectRef, method, args);
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public Frame execute(Frame frame, Object objectRef, Method method, Object[] arguments) throws Exception {
        ((AccessibleObject)method).setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(objectRef, arguments);
        }
        catch (Exception exception) {
            frame.getOperandStack().push(exception.getCause());
            throw new InterpreterException("ATHROW created");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            frame.getOperandStack().push(result);
        }
        return null;
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 183;
    }
}

