/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations.reflection;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantMethodref;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class INVOKESTATIC
extends InvokeOperation {
    public static final int OP = 184;
    protected int index = -1;
    private static final Map CACHE = new HashMap();

    public INVOKESTATIC(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame execute(Frame frame) {
        try {
            Class[] parameterTypes;
            Method method = null;
            ConstantMethodref constantMethodref = (ConstantMethodref)frame.getConstantPool()[this.index];
            if (CACHE.containsKey(constantMethodref)) {
                method = (Method)CACHE.get(constantMethodref);
            } else {
                Class referenceClass = constantMethodref.getConstantClass().getValue().getClassValue();
                parameterTypes = new MethodSignature(constantMethodref.getConstantNameAndType().getDescriptor()).getParameterTypes();
                String methodName = constantMethodref.getConstantNameAndType().getName();
                method = ClassUtil.resolveMethod(referenceClass, methodName, parameterTypes);
                CACHE.put(constantMethodref, method);
            }
            OperandStack operandStack = frame.getOperandStack();
            synchronized (operandStack) {
                parameterTypes = method.getParameterTypes();
                Object[] args = new Object[parameterTypes.length];
                for (int i = args.length - 1; i > -1; --i) {
                    args[i] = Primitive.cast(parameterTypes[i], frame.getOperandStack().pop());
                }
                return this.execute(frame, method.getDeclaringClass(), method, args);
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public Frame execute(Frame frame, Object objectRef, Method method, Object[] arguments) throws Exception {
        ((AccessibleObject)method).setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(objectRef, arguments);
        }
        catch (Exception exception) {
            frame.getOperandStack().push(exception.getCause());
            throw new InterpreterException("ATHROW created");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            frame.getOperandStack().push(result);
        }
        return null;
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 184;
    }
}

