/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.process;

import java.util.Stack;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.Interpreter;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public abstract class Process
extends EventProducer {
    public static final EventType STATE_CHANGE_EVENT = new EventType("STATE_CHANGE_EVENT");
    public static final short INITIAL = 0;
    public static final short EXECUTING = 1;
    public static final short SUSPENDED = 2;
    public static final short DEAD = 3;
    protected short state = 0;
    private Stack frameStack = new Stack();

    public Process() {
        try {
            this.frameStack.push(Interpreter.createFrame(this, ClassUtil.resolveMethod((Object)this, "process", null), null));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, "<init>", exception);
        }
    }

    public abstract void process();

    public synchronized void resume() {
        if (this.frameStack.isEmpty()) {
            this.setState((short)3);
            return;
        }
        try {
            this.setState((short)1);
            ((Frame)this.frameStack.peek()).setPaused(false);
            Object result = Interpreter.interpret(this.frameStack);
            if (result instanceof Stack) {
                this.frameStack = (Stack)result;
            }
        }
        catch (InterpreterException exception) {
            Logger.warning((Object)this, "<init>", exception);
        }
    }

    protected void suspend() {
        throw new RuntimeException("suspend should be interpreted. One may not invoke this method directly. If this exception occurs, make sure that the method that invoked it, was interpreted.");
    }

    protected void setState(short state) {
        if (this.state == 2 && state == 2) {
            throw new IllegalStateException("Cannot suspend a suspended process");
        }
        this.state = state;
        super.fireEvent(STATE_CHANGE_EVENT, state);
    }

    public short getState() {
        return this.state;
    }
}

