/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import nl.javel.gisbeans.io.EndianInterface;

public class ObjectEndianInputStream
implements EndianInterface,
DataInput {
    private DataInputStream dataInputStream;
    private InputStream inputStream;
    private byte[] buffer = new byte[8];
    private int encode = 0;

    public ObjectEndianInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.dataInputStream = new DataInputStream(inputStream);
    }

    public final short readShort() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readShort();
        }
        this.dataInputStream.readFully(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    public final int readUnsignedShort() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readUnsignedShort();
        }
        this.dataInputStream.readFully(this.buffer, 0, 2);
        return (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public final char readChar() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readChar();
        }
        this.dataInputStream.readFully(this.buffer, 0, 2);
        return (char)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    public final int readInt() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readInt();
        }
        this.dataInputStream.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public final long readLong() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readLong();
        }
        this.dataInputStream.readFully(this.buffer, 0, 8);
        return (long)this.buffer[7] << 56 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[0] & 0xFF);
    }

    public final float readFloat() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readFloat();
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        if (this.encode == 0) {
            return this.dataInputStream.readDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public final int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    public final void readFully(byte[] b) throws IOException {
        this.dataInputStream.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.dataInputStream.readFully(b, off, len);
    }

    public final int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    public final boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    public final String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public final String readLine() {
        return null;
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        return DataInputStream.readUTF(dataInput);
    }

    public final void close() throws IOException {
        this.dataInputStream.close();
    }

    public void setEncode(int encode) {
        this.encode = encode;
    }

    public int getEncode() {
        return this.encode;
    }
}

