/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nl.javel.gisbeans.io.EndianInterface;

public class ObjectEndianOutputStream
implements EndianInterface,
DataOutput {
    private DataOutputStream dataOutputStream = null;
    private byte[] buffer = new byte[8];
    private int encode = 0;

    public ObjectEndianOutputStream(OutputStream outputStream) {
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        this.dataOutputStream.write(this.buffer, off, len);
    }

    public void writeFloat(float value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeFloat(value);
        } else {
            this.writeInt(Float.floatToIntBits(value));
        }
    }

    public void write(int value) throws IOException {
        this.dataOutputStream.write(value);
    }

    public void writeShort(int value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeShort(value);
        } else {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.dataOutputStream.write(this.buffer, 0, 2);
        }
    }

    public void writeBytes(String string) throws IOException {
        this.dataOutputStream.writeBytes(string);
    }

    public void writeChar(int value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeChar(value);
        } else {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.dataOutputStream.write(this.buffer, 0, 2);
        }
    }

    public void writeByte(int value) throws IOException {
        this.dataOutputStream.writeByte(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.dataOutputStream.writeBoolean(value);
    }

    public void writeLong(long value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeLong(value);
        } else {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
            this.buffer[4] = (byte)(value >> 32);
            this.buffer[5] = (byte)(value >> 40);
            this.buffer[6] = (byte)(value >> 48);
            this.buffer[7] = (byte)(value >> 56);
            this.dataOutputStream.write(this.buffer, 0, 8);
        }
    }

    public void writeUTF(String string) throws IOException {
        this.dataOutputStream.writeUTF(string);
    }

    public void writeInt(int value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeInt(value);
        } else {
            this.buffer[0] = (byte)value;
            this.buffer[1] = (byte)(value >> 8);
            this.buffer[2] = (byte)(value >> 16);
            this.buffer[3] = (byte)(value >> 24);
            this.dataOutputStream.write(this.buffer, 0, 4);
        }
    }

    public void writeChars(String string) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeChars(string);
        } else {
            int length = string.length();
            int i = 0;
            while (i < length) {
                this.writeChar(string.charAt(i));
                ++i;
            }
        }
    }

    public void write(byte[] buffer) throws IOException {
        this.dataOutputStream.write(this.buffer, 0, this.buffer.length);
    }

    public void writeDouble(double value) throws IOException {
        if (this.encode == 0) {
            this.dataOutputStream.writeDouble(value);
        } else {
            this.writeLong(Double.doubleToLongBits(value));
        }
    }

    public final int size() {
        return this.dataOutputStream.size();
    }

    public void flush() throws IOException {
        this.dataOutputStream.flush();
    }

    public void close() throws IOException {
        this.dataOutputStream.close();
    }

    public void setEncode(int encode) {
        this.encode = encode;
    }

    public int getEncode() {
        return this.encode;
    }
}

