/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.io.esri;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import nl.javel.gisbeans.io.ObjectEndianInputStream;

public class DbfReader
implements Serializable {
    private URL dbfFile;
    private int[] columnLength;
    private String[] columnNames;
    private int headerLength = 0;
    private int numColumns = 0;
    private int numRecords = 0;
    private int recordLength = 0;
    private transient String[][] cachedContent = null;
    private boolean cache = true;

    public DbfReader(URL dbfFile) throws IOException {
        this.dbfFile = dbfFile;
        ObjectEndianInputStream dbfInput = new ObjectEndianInputStream(dbfFile.openStream());
        if (dbfInput.readByte() != 3) {
            throw new IOException("dbf file does not seem to be a Dbase III file");
        }
        dbfInput.skipBytes(3);
        dbfInput.setEncode(1);
        this.numRecords = dbfInput.readInt();
        this.headerLength = dbfInput.readShort();
        this.numColumns = (this.headerLength - 33) / 32;
        this.recordLength = dbfInput.readShort();
        this.columnLength = new int[this.numColumns];
        this.columnNames = new String[this.numColumns];
        dbfInput.skipBytes(20);
        int i = 0;
        while (i < this.numColumns) {
            StringBuffer buffer = new StringBuffer();
            int j = 0;
            while (j < 10) {
                byte b = dbfInput.readByte();
                if (b > 31) {
                    buffer.append((char)b);
                }
                ++j;
            }
            this.columnNames[i] = buffer.toString();
            dbfInput.setEncode(0);
            dbfInput.readChar();
            dbfInput.skipBytes(4);
            this.columnLength[i] = dbfInput.readByte();
            if (this.columnLength[i] < 0) {
                int n = i;
                this.columnLength[n] = this.columnLength[n] + 256;
            }
            dbfInput.skipBytes(15);
            ++i;
        }
        dbfInput.close();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getRow(int rowNumber) throws IOException, IndexOutOfBoundsException {
        if (rowNumber > this.numRecords) {
            throw new IndexOutOfBoundsException("dbfFile : rowNumber > numRecords");
        }
        if (this.cachedContent != null && this.cache) {
            return this.cachedContent[rowNumber];
        }
        String[] row = new String[this.numColumns];
        ObjectEndianInputStream dbfInput = new ObjectEndianInputStream(this.dbfFile.openStream());
        dbfInput.skipBytes(this.headerLength + 1);
        dbfInput.skipBytes(rowNumber * this.recordLength);
        int i = 0;
        while (i < this.numColumns) {
            byte[] bytes = new byte[this.columnLength[i]];
            dbfInput.read(bytes);
            row[i] = new String(bytes);
            ++i;
        }
        dbfInput.close();
        return row;
    }

    public String[][] getRows() throws IOException {
        if (this.cachedContent != null && this.cache) {
            return this.cachedContent;
        }
        String[][] result = new String[this.numRecords][this.numColumns];
        ObjectEndianInputStream dbfInput = new ObjectEndianInputStream(this.dbfFile.openStream());
        dbfInput.skipBytes(this.headerLength + 1);
        int row = 0;
        while (row < this.numRecords) {
            int col = 0;
            while (col < this.numColumns) {
                byte[] bytes = new byte[this.columnLength[col]];
                dbfInput.read(bytes);
                result[row][col] = new String(bytes);
                if (col == this.numColumns - 1) {
                    dbfInput.skipBytes(1);
                }
                ++col;
            }
            ++row;
        }
        dbfInput.close();
        if (this.cache) {
            this.cachedContent = result;
        }
        return result;
    }

    public int[] getRowNumbers(String attribute, String columnName) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[][] rows = this.getRows();
        int col = 0;
        while (col < this.numColumns) {
            if (this.columnNames[col].equals(columnName)) {
                int row = 0;
                while (row < this.numRecords) {
                    if (rows[row][col].equals(attribute)) {
                        result.add(new Integer(row));
                    }
                    ++row;
                }
            }
            ++col;
        }
        int[] array = new int[result.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Integer)result.get(i);
            ++i;
        }
        return array;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

