/*
 * Decompiled with CFR 0.152.
 */
package nl.javel.gisbeans.io.esri;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import nl.javel.gisbeans.geom.GisObject;
import nl.javel.gisbeans.geom.SerializableGeneralPath;
import nl.javel.gisbeans.io.DataSourceInterface;
import nl.javel.gisbeans.io.ObjectEndianInputStream;
import nl.javel.gisbeans.io.esri.DbfReader;
import nl.tudelft.simulation.language.d2.Shape;

public class ShapeFile
implements DataSourceInterface {
    private URL shpFile = null;
    private URL shxFile = null;
    private URL dbfFile = null;
    private int numShapes = 0;
    private int type = 0;
    private DbfReader dbfReader;
    public static final int NULLSHAPE = 0;
    public static final int POINT = 1;
    public static final int POLYLINE = 3;
    public static final int POLYGON = 5;
    public static final int MULTIPOINT = 8;
    public static final int POINTZ = 11;
    public static final int POLYLINEZ = 13;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINTZ = 18;
    public static final int POINTM = 21;
    public static final int POLYLINEM = 23;
    public static final int POLYGONM = 25;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPATCH = 31;
    private boolean cache = true;
    private ArrayList cachedContent = null;

    public ShapeFile(URL url) throws IOException {
        String fileName = url.toString();
        if (fileName.endsWith(".shp") || fileName.endsWith(".shx") || fileName.endsWith(".dbf")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        this.shpFile = new URL(String.valueOf(fileName) + ".shp");
        this.shxFile = new URL(String.valueOf(fileName) + ".shx");
        this.dbfFile = new URL(String.valueOf(fileName) + ".dbf");
        try {
            URLConnection connection = this.shxFile.openConnection();
            connection.connect();
            this.numShapes = (connection.getContentLength() - 100) / 8;
            this.dbfReader = new DbfReader(this.dbfFile);
        }
        catch (IOException exception) {
            throw new IOException("Can't read " + this.shxFile.toString());
        }
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
        this.dbfReader.setCache(cache);
    }

    public String[] getColumnNames() {
        return this.dbfReader.getColumnNames();
    }

    public String[][] getAttributes() throws IOException {
        return this.dbfReader.getRows();
    }

    public URL getDataSource() {
        return this.shpFile;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public synchronized GisObject getShape(int index) throws IOException {
        if (index > this.numShapes || index < 0) {
            throw new IndexOutOfBoundsException("Index =" + index + " number of shapes in layer :" + this.numShapes);
        }
        if (this.cache && this.cachedContent != null) {
            return (GisObject)this.cachedContent.get(index);
        }
        ObjectEndianInputStream indexInput = new ObjectEndianInputStream(this.shxFile.openStream());
        indexInput.skipBytes(8 * index + 100);
        int offset = 2 * indexInput.readInt();
        indexInput.close();
        ObjectEndianInputStream shapeInput = new ObjectEndianInputStream(this.shpFile.openStream());
        shapeInput.skipBytes(offset);
        Object shape = this.readShape(shapeInput);
        shapeInput.close();
        return new GisObject(shape, this.dbfReader.getRow(index));
    }

    public synchronized List getShapes() throws IOException {
        if (this.cache && this.cachedContent != null) {
            return this.cachedContent;
        }
        ObjectEndianInputStream shapeInput = new ObjectEndianInputStream(this.shpFile.openStream());
        shapeInput.skipBytes(100);
        ArrayList<GisObject> results = new ArrayList<GisObject>(this.numShapes);
        String[][] attributes = this.dbfReader.getRows();
        int i = 0;
        while (i < this.numShapes) {
            results.add(new GisObject(this.readShape(shapeInput), attributes[i]));
            ++i;
        }
        shapeInput.close();
        if (this.cache) {
            this.cachedContent = results;
        }
        return results;
    }

    public synchronized List getShapes(Rectangle2D extent) throws IOException {
        if (!this.cache) {
            if (this.cachedContent == null) {
                this.getShapes();
            }
            ArrayList<GisObject> result = new ArrayList<GisObject>();
            Iterator i = this.cachedContent.iterator();
            while (i.hasNext()) {
                GisObject shape = (GisObject)i.next();
                if (shape.getShape() instanceof SerializableGeneralPath) {
                    if (!Shape.overlaps((Rectangle2D)extent, (Rectangle2D)((SerializableGeneralPath)shape.getShape()).getBounds2D())) continue;
                    result.add(shape);
                    continue;
                }
                if (shape.getShape() instanceof Point2D) {
                    if (!extent.contains((Point2D)shape.getShape())) continue;
                    result.add(shape);
                    continue;
                }
                Logger.getLogger("nl.javel.gisbeans").severe("unknown shape in cached content " + shape);
            }
            return result;
        }
        ObjectEndianInputStream shapeInput = new ObjectEndianInputStream(this.shpFile.openStream());
        shapeInput.skipBytes(100);
        ArrayList<GisObject> results = new ArrayList<GisObject>();
        String[][] attributes = this.dbfReader.getRows();
        int i = 0;
        while (i < this.numShapes) {
            Point2D temp;
            shapeInput.setEncode(0);
            int shapeNumber = shapeInput.readInt();
            int contentLength = shapeInput.readInt();
            shapeInput.setEncode(1);
            int type = shapeInput.readInt();
            if (type != 0 && type != 1 && type != 11 && type != 21) {
                double height;
                double width;
                double minY;
                double minX = shapeInput.readDouble();
                Rectangle2D.Double bounds = new Rectangle2D.Double(minX, minY = shapeInput.readDouble(), width = shapeInput.readDouble() - minX, height = shapeInput.readDouble() - minY);
                if (Shape.overlaps((Rectangle2D)extent, (Rectangle2D)bounds)) {
                    results.add(new GisObject(this.readShape(shapeInput, shapeNumber, contentLength, type, false), attributes[i]));
                } else {
                    shapeInput.skipBytes(2 * contentLength - 36);
                }
            } else if (type != 0 && extent.contains(temp = (Point2D)this.readShape(shapeInput, shapeNumber, contentLength, type, false))) {
                results.add(new GisObject(temp, attributes[i]));
            }
            ++i;
        }
        shapeInput.close();
        return results;
    }

    public synchronized List getShapes(String attribute, String columnName) throws IOException {
        ArrayList<GisObject> result = new ArrayList<GisObject>();
        int[] shapeNumbers = this.dbfReader.getRowNumbers(attribute, columnName);
        int i = 0;
        while (i < shapeNumbers.length) {
            result.add(this.getShape(i));
            ++i;
        }
        return result;
    }

    public int getType() {
        return this.type;
    }

    private Object readShape(ObjectEndianInputStream input) throws IOException {
        return this.readShape(input, -1, -1, -1, true);
    }

    private Object readShape(ObjectEndianInputStream input, int shapeNumber, int contentLength, int type, boolean skipBox) throws IOException {
        input.setEncode(0);
        if (shapeNumber == -1) {
            shapeNumber = input.readInt();
        }
        if (contentLength == -1) {
            contentLength = input.readInt();
        }
        input.setEncode(1);
        if (type == -1) {
            type = input.readInt();
        }
        switch (type) {
            case 0: {
                return this.readNullShape(input);
            }
            case 1: {
                return this.readPoint(input);
            }
            case 3: {
                return this.readPolyLine(input, skipBox);
            }
            case 5: {
                return this.readPolygon(input, skipBox);
            }
            case 8: {
                return this.readMultiPoint(input, skipBox);
            }
            case 11: {
                return this.readPointZ(input, contentLength);
            }
            case 13: {
                return this.readPolyLineZ(input, contentLength, skipBox);
            }
            case 15: {
                return this.readPolygonZ(input, contentLength, skipBox);
            }
            case 18: {
                return this.readMultiPointZ(input, contentLength, skipBox);
            }
            case 21: {
                return this.readPointM(input, contentLength);
            }
            case 23: {
                return this.readPolyLineM(input, contentLength, skipBox);
            }
            case 25: {
                return this.readPolygonM(input, contentLength, skipBox);
            }
            case 28: {
                return this.readMultiPointM(input, contentLength, skipBox);
            }
            case 31: {
                return this.readMultiPatch(input, contentLength, skipBox);
            }
        }
        throw new IOException("Unknown shape type or shape type not supported");
    }

    private synchronized Object readNullShape(ObjectEndianInputStream input) throws IOException {
        if (input != null) {
            throw new IOException("readNullShape inputStream is is not null");
        }
        return null;
    }

    private synchronized Object readPoint(ObjectEndianInputStream input) throws IOException {
        this.type = 1;
        input.setEncode(1);
        return new Point2D.Double(input.readDouble(), input.readDouble());
    }

    private synchronized Object readPolyLine(ObjectEndianInputStream input, boolean skipBox) throws IOException {
        this.type = 2;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                ++ii;
            }
            ++i2;
        }
        return result;
    }

    private synchronized Object readPolygon(ObjectEndianInputStream input, boolean skipBox) throws IOException {
        this.type = 0;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                ++ii;
            }
            ++i2;
        }
        return result;
    }

    private synchronized Object readMultiPoint(ObjectEndianInputStream input, boolean skipBox) throws IOException {
        this.type = 1;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        Point2D.Double[] result = new Point2D.Double[input.readInt()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Point2D)this.readPoint(input);
            ++i;
        }
        return result;
    }

    private synchronized Object readPointZ(ObjectEndianInputStream input, int contentLength) throws IOException {
        this.type = 1;
        Object point = this.readPoint(input);
        input.skipBytes(contentLength * 2 - 20);
        return point;
    }

    private synchronized Object readPolyLineZ(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 2;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int byteCounter = 44;
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            byteCounter += 4;
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            byteCounter += 16;
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                byteCounter += 16;
                ++ii;
            }
            ++i2;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readPolygonZ(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 0;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int byteCounter = 44;
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            byteCounter += 4;
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            byteCounter += 16;
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                byteCounter += 16;
                ++ii;
            }
            ++i2;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readMultiPointZ(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 1;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        Point2D.Double[] result = new Point2D.Double[input.readInt()];
        int byteCounter = 40;
        int i = 0;
        while (i < result.length) {
            result[i] = (Point2D)this.readPoint(input);
            byteCounter += 16;
            ++i;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readPointM(ObjectEndianInputStream input, int contentLength) throws IOException {
        this.type = 1;
        Object point = this.readPoint(input);
        input.skipBytes(contentLength * 2 - 20);
        return point;
    }

    private synchronized Object readPolyLineM(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 2;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int byteCounter = 44;
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            byteCounter += 4;
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            byteCounter += 16;
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                byteCounter += 16;
                ++ii;
            }
            ++i2;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readPolygonM(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 0;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        int numParts = input.readInt();
        int numPoints = input.readInt();
        int byteCounter = 44;
        int[] partBegin = new int[numParts + 1];
        int i = 0;
        while (i < partBegin.length - 1) {
            partBegin[i] = input.readInt();
            byteCounter += 4;
            ++i;
        }
        partBegin[partBegin.length - 1] = numPoints;
        SerializableGeneralPath result = new SerializableGeneralPath(1, numPoints);
        int i2 = 0;
        while (i2 < numParts) {
            result.moveTo((float)input.readDouble(), (float)input.readDouble());
            byteCounter += 16;
            int ii = partBegin[i2] + 1;
            while (ii < partBegin[i2 + 1]) {
                result.lineTo((float)input.readDouble(), (float)input.readDouble());
                byteCounter += 16;
                ++ii;
            }
            ++i2;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readMultiPointM(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        this.type = 1;
        if (skipBox) {
            input.skipBytes(32);
        }
        input.setEncode(1);
        Point2D.Double[] result = new Point2D.Double[input.readInt()];
        int byteCounter = 40;
        int i = 0;
        while (i < result.length) {
            result[i] = (Point2D)this.readPoint(input);
            byteCounter += 16;
            ++i;
        }
        input.skipBytes(contentLength * 2 - byteCounter);
        return result;
    }

    private synchronized Object readMultiPatch(ObjectEndianInputStream input, int contentLength, boolean skipBox) throws IOException {
        if (input != null || contentLength != 0 || skipBox) {
            throw new IOException("Please inform <a href=\"mailto:support@javel.nl\">support@javel.nl</a> that you need MultiPatch support");
        }
        return null;
    }
}

