/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.fields;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.fields.FieldProperty;
import nl.tudelft.simulation.logger.Logger;

public class FieldIntrospector
implements Introspector {
    private boolean useDeepIntrospection = true;

    public FieldIntrospector() {
        this(false);
    }

    public FieldIntrospector(boolean useDeepIntrospection) {
        this.useDeepIntrospection = useDeepIntrospection;
    }

    public Property[] getProperties(Object introspected) {
        HashSet<FieldProperty> props = new HashSet<FieldProperty>();
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            int i = 0;
            while (i < fields.length) {
                props.add(new FieldProperty(introspected, fields[i]));
                ++i;
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperties", (Throwable)e);
        }
        return props.toArray(new Property[props.size()]);
    }

    private Field[] collectFields(Class clasz) {
        ArrayList fields = new ArrayList(10);
        this.addFields(fields, clasz, this.useDeepIntrospection);
        return fields.toArray(new Field[fields.size()]);
    }

    private void addFields(List fieldList, Class clasz, boolean iterate) {
        fieldList.addAll(Arrays.asList(clasz.getDeclaredFields()));
        if (iterate && clasz.getSuperclass() != null) {
            this.addFields(fieldList, clasz.getSuperclass(), iterate);
        }
    }

    public Property getProperty(Object introspected, String property) {
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().equals(property)) {
                    return new FieldProperty(introspected, fields[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getProperty", (Throwable)e);
        }
        throw new IllegalArgumentException("Property '" + property + "' not found for " + introspected);
    }

    public String[] getPropertyNames(Object introspected) {
        HashSet<String> props = new HashSet<String>();
        try {
            Field[] fields = this.collectFields(introspected.getClass());
            int i = 0;
            while (i < fields.length) {
                props.add(fields[i].getName());
                ++i;
            }
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"getPropertyNames", (Throwable)e);
        }
        return props.toArray(new String[props.size()]);
    }
}

