/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.introspection.AbstractProperty;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import nl.tudelft.simulation.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.introspection.gui.ExpandButton;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ModelManager;
import nl.tudelft.simulation.introspection.table.DynamicTableModel;
import nl.tudelft.simulation.logger.Logger;

public class CollectionTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface,
DynamicTableModel {
    protected Map instances = Collections.synchronizedMap(new HashMap(20));
    protected List keys = Collections.synchronizedList(new ArrayList(20));
    private Class componentType = null;
    private static final String[] COLUMNS = new String[]{"#", "+", "Instance"};
    private List buttons = Collections.synchronizedList(new ArrayList(20));
    private Property parentProperty;
    private Introspector introspector;
    private ModelManager manager = new DefaultModelManager();
    private int maxKey = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CollectionTableModel(Property parentProperty) {
        this(parentProperty, new BeanIntrospector());
    }

    public CollectionTableModel(Property parentProperty, Introspector introspector) {
        Object values = parentProperty.getValue();
        if (values.getClass().isArray()) {
            int i = 0;
            while (i < Array.getLength(values)) {
                this.addValue(Array.get(values, i));
                ++i;
            }
        }
        if (values instanceof Collection) {
            Iterator i = ((Collection)values).iterator();
            while (i.hasNext()) {
                this.addValue(i.next());
            }
        }
        this.parentProperty = parentProperty;
        this.introspector = introspector;
        int i = 0;
        while (i < this.instances.size()) {
            this.buttons.add(new ExpandButton(this.getProperty(i), this));
            ++i;
        }
    }

    private void addValue(Object value) {
        Integer nextKey = new Integer(this.maxKey++);
        this.keys.add(nextKey);
        this.instances.put(nextKey, value);
    }

    public int getRowCount() {
        return this.instances.size();
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return new Integer(rowIndex);
        }
        if (columnIndex == 1) {
            return this.buttons.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex));
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            Integer key = (Integer)this.keys.get(rowIndex);
            this.instances.put(key, aValue);
        }
        this.update();
    }

    private void update() {
        ArrayList newValue = new ArrayList(this.keys.size());
        int i = 0;
        while (i < this.keys.size()) {
            newValue.add(this.instances.get(this.keys.get(i)));
            ++i;
        }
        this.parentProperty.setValue(newValue);
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nl.tudelft.simulation.introspection.gui.ExpandButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Property getProperty(String propertyName) {
        int index = Integer.parseInt(propertyName);
        return this.getProperty(index);
    }

    protected Property getProperty(int index) {
        return new CollectionProperty((Integer)this.keys.get(index), this.parentProperty.getName());
    }

    public void createRow() {
        if (this.componentType == null) {
            this.componentType = this.parentProperty.getComponentType();
            if (this.componentType == null) {
                return;
            }
        }
        try {
            Constructor instanceConstructor = this.componentType.getConstructor(new Class[0]);
            Object instance = instanceConstructor.newInstance(new Object[0]);
            this.addValue(instance);
            this.buttons.add(new ExpandButton(this.getProperty(this.instances.size() - 1), this));
            this.update();
        }
        catch (Exception e) {
            Logger.warning((Object)this, (String)"createRow", (String)("Could not instantiate new instance: " + e.getMessage()));
        }
    }

    public void createRows(int amount) {
        int i = 0;
        while (i < amount) {
            this.createRow();
            ++i;
        }
    }

    public void deleteRow(int index) {
        Integer deletionKey = (Integer)this.keys.get(index);
        this.instances.remove(deletionKey);
        this.keys.remove(index);
        this.buttons.remove(index);
        this.update();
    }

    public synchronized void deleteRows(int[] indices) {
        Arrays.sort(indices);
        int i = indices.length - 1;
        while (i >= 0) {
            this.deleteRow(indices[i]);
            --i;
        }
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public Class getTypeAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (columnIndex == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nl.tudelft.simulation.introspection.gui.ExpandButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (columnIndex == 2) {
            return this.instances.get(this.keys.get(rowIndex)).getClass();
        }
        return null;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    public ModelManager getModelManager() {
        return this.manager;
    }

    public boolean isRowEditable() {
        return this.parentProperty.isEditable();
    }

    class CollectionProperty
    extends AbstractProperty
    implements Property {
        private final Integer key;
        private final String name;

        public CollectionProperty(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public Object getInstance() {
            return CollectionTableModel.this.instances.values();
        }

        public String getName() {
            return String.valueOf(this.name) + "[" + CollectionTableModel.this.keys.indexOf(this.key) + "]";
        }

        public Class getType() {
            return CollectionTableModel.this.instances.get(this.key).getClass();
        }

        public Object getValue() {
            return CollectionTableModel.this.instances.get(this.key);
        }

        public boolean isEditable() {
            return true;
        }

        protected void setRegularValue(Object value) {
            throw new IllegalArgumentException(this + " is only supposed to be" + " set to composite values." + "A program is not supposed to arrive here.");
        }

        public String toString() {
            return "Coll.Prop, key:" + this.key;
        }
    }
}

