/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import nl.tudelft.simulation.introspection.gui.ICellPresentationConfigProvider;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ObjectJTableInterface;
import nl.tudelft.simulation.introspection.gui.SortingObjectTableModel;
import nl.tudelft.simulation.introspection.gui.UpdateTimer;
import nl.tudelft.simulation.introspection.mapping.CellPresentationConfiguration;
import nl.tudelft.simulation.introspection.mapping.DefaultConfiguration;
import nl.tudelft.simulation.introspection.sortable.SortDefinition;
import nl.tudelft.simulation.introspection.sortable.SortingTableHeader;

public class ObjectJTable
extends JTable
implements ObjectJTableInterface,
ICellPresentationConfigProvider {
    private static UpdateTimer updateTimer = new UpdateTimer(100L);
    protected boolean hasShown = false;
    private IntrospectingTableModelInterface introspectionTableModel;
    private final CellPresentationConfiguration CONFIG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ObjectJTable(IntrospectingTableModelInterface dm) {
        this(dm, DefaultConfiguration.getDefaultConfiguration());
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, CellPresentationConfiguration config) {
        super(new SortingObjectTableModel(dm));
        this.CONFIG = config;
        this.init(dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm) {
        super(new SortingObjectTableModel(dm), cm);
        this.CONFIG = DefaultConfiguration.getDefaultConfiguration();
        this.init(dm);
    }

    public ObjectJTable(IntrospectingTableModelInterface dm, TableColumnModel cm, ListSelectionModel sm) {
        super(new SortingObjectTableModel(dm), cm, sm);
        this.CONFIG = DefaultConfiguration.getDefaultConfiguration();
        this.init(dm);
    }

    public CellPresentationConfiguration getCellPresentationConfiguration() {
        return this.CONFIG;
    }

    private void init(IntrospectingTableModelInterface model) {
        this.introspectionTableModel = model;
        this.initConfig();
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        SortingTableHeader header = new SortingTableHeader(new SortDefinition[]{new SortDefinition(0, true)});
        this.setTableHeader(header);
        ((JTableHeader)header).setColumnModel(this.getColumnModel());
        updateTimer.add(this);
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        if (columnClass.isArray()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.Object;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return super.getDefaultRenderer(clazz);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(columnClass)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return super.getDefaultRenderer(clazz2);
        }
        return super.getDefaultRenderer(columnClass);
    }

    private void initConfig() {
        this.addHierarchyListener(new ParentListener());
        Class[][] renderers = this.CONFIG.getRenderers();
        Class[][] editors = this.CONFIG.getEditors();
        try {
            int i = 0;
            while (i < renderers.length) {
                this.setDefaultRenderer(renderers[i][0], (TableCellRenderer)renderers[i][1].newInstance());
                ++i;
            }
            i = 0;
            while (i < editors.length) {
                this.setDefaultEditor(editors[i][0], (TableCellEditor)editors[i][1].newInstance());
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configuration " + this.CONFIG + "failed, " + "probably invalid classes.");
        }
        this.getColumn(this.getColumnName(0)).setPreferredWidth(70);
        this.getColumn(this.getColumnName(1)).setMaxWidth(25);
        this.getColumn(this.getColumnName(2)).setPreferredWidth(450);
        this.setAutoResizeMode(0);
    }

    public IntrospectingTableModelInterface getIntrospectingTableModel() {
        return this.introspectionTableModel;
    }

    private class ParentListener
    implements HierarchyListener {
        ParentListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 2L) {
                if (!ObjectJTable.this.hasShown && ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.hasShown = true;
                    return;
                }
                if (ObjectJTable.this.hasShown && !ObjectJTable.this.isDisplayable()) {
                    ObjectJTable.this.getModel().removeTableModelListener(ObjectJTable.this);
                }
            }
        }
    }
}

