/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import javax.swing.table.AbstractTableModel;
import nl.tudelft.simulation.introspection.Introspector;
import nl.tudelft.simulation.introspection.Property;
import nl.tudelft.simulation.introspection.beans.BeanIntrospector;
import nl.tudelft.simulation.introspection.gui.DefaultModelManager;
import nl.tudelft.simulation.introspection.gui.ExpandButton;
import nl.tudelft.simulation.introspection.gui.IntrospectingTableModelInterface;
import nl.tudelft.simulation.introspection.gui.ModelManager;
import nl.tudelft.simulation.logger.Logger;

public class ObjectTableModel
extends AbstractTableModel
implements IntrospectingTableModelInterface {
    protected Property[] properties = new Property[0];
    private static String[] columns = new String[]{"Property", "+", "Value"};
    private ExpandButton[] buttons;
    private Introspector introspector = null;
    private ModelManager manager = new DefaultModelManager();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ObjectTableModel(Object bean) {
        this(bean, new BeanIntrospector());
    }

    public ObjectTableModel(Object object, Introspector introspector) {
        this.properties = introspector.getProperties(object);
        this.buttons = new ExpandButton[this.properties.length];
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = new ExpandButton(this.properties[i], this);
            ++i;
        }
        this.introspector = introspector;
    }

    public int getRowCount() {
        return this.properties.length;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            return requested.getName();
        }
        if (columnIndex == 1) {
            return this.buttons[rowIndex];
        }
        if (columnIndex == 2) {
            return requested.getValue();
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        return columns[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        if (columnIndex == 2) {
            return this.properties[rowIndex].isEditable() && !this.properties[rowIndex].getType().isArray();
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 2 || !this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        Property requested = this.properties[rowIndex];
        try {
            requested.setValue(aValue);
        }
        catch (IllegalArgumentException exception) {
            Logger.warning((Object)this, (String)"setValueAt", (Throwable)exception);
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nl.tudelft.simulation.introspection.gui.ExpandButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getTypeAt(int rowIndex, int columnIndex) {
        Property requested = this.properties[rowIndex];
        if (columnIndex == 0) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (columnIndex == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nl.tudelft.simulation.introspection.gui.ExpandButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (columnIndex == 2) {
            return requested.getType();
        }
        return null;
    }

    protected int getPropertyIndex(String property) {
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].getName().equalsIgnoreCase(property)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Property getProperty(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index == -1) {
            return null;
        }
        return this.properties[index];
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public void setModelManager(ModelManager manager) {
        this.manager = manager;
    }

    public ModelManager getModelManager() {
        return this.manager;
    }
}

