/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.gui;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateTimer
extends TimerTask {
    private WeakReference[] components = new WeakReference[0];
    private Timer timer = null;
    private long period = 300L;

    public UpdateTimer(long period) {
        this.period = period;
    }

    public synchronized void add(Component component) {
        ArrayList<WeakReference> arrayList = new ArrayList<WeakReference>(Arrays.asList(this.components));
        arrayList.add(new WeakReference<Component>(component));
        this.components = arrayList.toArray(new WeakReference[arrayList.size()]);
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)this, 0L, this.period);
        }
    }

    public synchronized void remove(Component component) {
        int i = this.components.length - 1;
        while (i > -1) {
            if (this.components[i].get().equals(component)) {
                this.remove(this.components[i]);
            }
            --i;
        }
    }

    private synchronized void remove(WeakReference reference) {
        ArrayList<WeakReference> arrayList = new ArrayList<WeakReference>(Arrays.asList(this.components));
        arrayList.remove(reference);
        this.components = arrayList.toArray(new WeakReference[arrayList.size()]);
        if (this.components.length == 0) {
            this.timer.cancel();
        }
    }

    public void run() {
        int i = this.components.length - 1;
        while (i > -1) {
            Component component = (Component)this.components[i].get();
            if (component != null) {
                component.repaint();
            } else {
                this.remove(this.components[i]);
            }
            --i;
        }
    }
}

