/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.sortable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.introspection.sortable.SortDefinition;
import nl.tudelft.simulation.introspection.sortable.Sortable;
import nl.tudelft.simulation.introspection.sortable.SortingHeaderCell;

public class SortingTableHeader
extends JTableHeader {
    protected List definitions = new ArrayList(5);

    public SortingTableHeader(Sortable.Definition[] defaultSorting) {
        this.definitions.addAll(Arrays.asList(defaultSorting));
        this.init();
    }

    private void init() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int column = SortingTableHeader.this.columnAtPoint(e.getPoint());
                TableColumn col = SortingTableHeader.this.getColumnModel().getColumn(column);
                SortingHeaderCell header = (SortingHeaderCell)col.getHeaderRenderer();
                header.changeSort();
                if (!e.isShiftDown()) {
                    SortingTableHeader.this.definitions.clear();
                    SortingTableHeader.this.clearHeaders(header);
                    if (header.isSorted()) {
                        SortingTableHeader.this.definitions.add(new SortDefinition(column, header.isAscendingSorted()));
                    }
                } else {
                    Sortable.Definition def = SortingTableHeader.this.getMatchingDef(column);
                    if (def == null) {
                        SortingTableHeader.this.definitions.add(new SortDefinition(column, header.isAscendingSorted()));
                    } else if (!header.isSorted()) {
                        SortingTableHeader.this.definitions.remove(def);
                    } else {
                        def.setAscending(header.isAscendingSorted());
                    }
                }
                SortingTableHeader.this.propagateSort();
            }
        });
    }

    protected Sortable.Definition getMatchingDef(int column) {
        Iterator i = this.definitions.iterator();
        while (i.hasNext()) {
            Sortable.Definition def = (Sortable.Definition)i.next();
            if (def.getFieldID() != column) continue;
            return def;
        }
        return null;
    }

    protected void clearHeaders(SortingHeaderCell butThisOne) {
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            SortingHeaderCell current = (SortingHeaderCell)this.getColumnModel().getColumn(i).getHeaderRenderer();
            if (!current.equals(butThisOne)) {
                current.setSort(0);
            }
            ++i;
        }
    }

    protected void propagateSort() {
        TableModel model = this.getTable().getModel();
        if (model instanceof Sortable) {
            ((Sortable)((Object)model)).setDefinitions(this.definitions.toArray(new SortDefinition[0]));
            ((Sortable)((Object)model)).sort();
        }
    }

    public void setColumnModel(TableColumnModel columnModel) {
        super.setColumnModel(columnModel);
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            int sort = this.getSort(i);
            this.getColumnModel().getColumn(i).setHeaderRenderer(new SortingHeaderCell(sort));
            ++i;
        }
    }

    private int getSort(int column) {
        Iterator i = this.definitions.iterator();
        while (i.hasNext()) {
            Sortable.Definition def = (Sortable.Definition)i.next();
            if (def.getFieldID() != column) continue;
            if (def.isAcendingSort()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void setTable(JTable table) {
        super.setTable(table);
        this.propagateSort();
    }
}

