/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.introspection.sortable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.introspection.sortable.Sortable;
import nl.tudelft.simulation.logger.Logger;

public class SortingTableModel
implements TableModel,
Sortable {
    protected Map proxyListeners = new HashMap(5);
    protected TableModel source;
    private List index = Collections.synchronizedList(new ArrayList());
    protected Integer[] expandedIndex;
    private List definitions = Collections.synchronizedList(new ArrayList());

    public SortingTableModel(TableModel source) {
        this.source = source;
    }

    private synchronized void buildIndex() {
        this.initIndex();
        Iterator i = this.definitions.iterator();
        while (i.hasNext()) {
            Sortable.Definition definition = (Sortable.Definition)i.next();
            this.index = this.sortList(this.index, definition.isAcendingSort(), definition.getFieldID());
        }
        this.expandIndex();
    }

    private void expandIndex() {
        ArrayList expandedList = new ArrayList();
        Iterator i = this.index.iterator();
        while (i.hasNext()) {
            Object current = i.next();
            if (current instanceof List) {
                expandedList.addAll((List)current);
                continue;
            }
            expandedList.add(current);
        }
        this.expandedIndex = expandedList.toArray(new Integer[0]);
    }

    private void initIndex() {
        this.index.clear();
        ArrayList<Integer> entry = new ArrayList<Integer>();
        int i = 0;
        while (i < this.getRowCount()) {
            entry.add(new Integer(i));
            ++i;
        }
        this.index.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List sortList(List unsorted, boolean ascending, int column) {
        ArrayList result = new ArrayList(unsorted.size());
        List list = unsorted;
        synchronized (list) {
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                Object current = i.next();
                if (current instanceof Integer) {
                    result.add(current);
                    continue;
                }
                List currentList = (List)current;
                result.addAll(this.sortSubList(currentList, ascending, column));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List sortSubList(List unsorted, boolean ascending, int column) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(unsorted.size());
        List list = unsorted;
        synchronized (list) {
            int i = 0;
            while (i < unsorted.size()) {
                Integer unsortedEntry = (Integer)unsorted.get(i);
                Object current = this.source.getValueAt(unsortedEntry, column);
                boolean allocated = false;
                int y = 0;
                while (y < result.size() && !allocated) {
                    boolean inList = false;
                    Object resultValue = result.get(y);
                    if (resultValue instanceof List) {
                        inList = true;
                        resultValue = this.source.getValueAt((Integer)((List)resultValue).get(0), column);
                    } else {
                        resultValue = this.source.getValueAt((Integer)resultValue, column);
                    }
                    if (current instanceof Comparable && resultValue instanceof Comparable) {
                        try {
                            int comparisson = ((Comparable)current).compareTo(resultValue);
                            if (comparisson == 0) {
                                if (inList) {
                                    ((List)result.get(y)).add(unsortedEntry);
                                } else {
                                    ArrayList valueList = new ArrayList(2);
                                    valueList.add(result.get(y));
                                    valueList.add(unsortedEntry);
                                    result.remove(y);
                                    result.add(y, valueList);
                                }
                                allocated = true;
                            }
                            if (ascending && comparisson < 0 || !ascending && comparisson > 0) {
                                result.add(y, unsortedEntry);
                                allocated = true;
                            }
                        }
                        catch (ClassCastException exception) {
                            Logger.info((Object)this, (String)"sortSubList", (String)(" Could not compare " + current + " and " + resultValue + ": " + exception));
                        }
                    }
                    ++y;
                }
                if (!allocated) {
                    result.add(unsortedEntry);
                }
                ++i;
            }
        }
        return result;
    }

    public Sortable.Definition[] getDefinitions() {
        return this.definitions.toArray(new Sortable.Definition[0]);
    }

    public void setDefinitions(Sortable.Definition[] definitions) {
        this.definitions.clear();
        this.definitions.addAll(Arrays.asList(definitions));
    }

    public void sort() {
        this.buildIndex();
    }

    public void addTableModelListener(TableModelListener l) {
        ProxyListener proxy = new ProxyListener();
        this.proxyListeners.put(proxy, l);
        this.source.addTableModelListener(proxy);
    }

    public Class getColumnClass(int columnIndex) {
        return this.source.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return this.source.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.source.getColumnName(columnIndex);
    }

    public int getRowCount() {
        return this.source.getRowCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.expandedIndex == null) {
            this.buildIndex();
        }
        if (rowIndex > this.expandedIndex.length) {
            Logger.warning((Object)this, (String)"getValueAt", (String)(" could not retrieve row " + rowIndex + " from sorted list. Returning default instead."));
            return this.source.getValueAt(rowIndex, columnIndex);
        }
        return this.source.getValueAt(this.expandedIndex[rowIndex], columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.source.isCellEditable(this.expandedIndex[rowIndex], columnIndex);
    }

    public void removeTableModelListener(TableModelListener l) {
        ProxyListener proxy = (ProxyListener)this.proxyListeners.get(l);
        this.source.removeTableModelListener(proxy);
        this.proxyListeners.remove(proxy);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.expandedIndex.length) {
            Logger.warning((Object)this, (String)"setValueAt", (String)(" could not retrieve row " + rowIndex + " from sorted list. Ignoring 'setValue' command."));
            return;
        }
        this.source.setValueAt(aValue, this.expandedIndex[rowIndex], columnIndex);
        this.buildIndex();
        if (this.source instanceof DefaultTableModel) {
            ((DefaultTableModel)this.source).fireTableDataChanged();
        }
    }

    private class ProxyListener
    implements TableModelListener {
        ProxyListener() {
        }

        public void tableChanged(TableModelEvent e) {
            SortingTableModel.this.sort();
            ((TableModelListener)SortingTableModel.this.proxyListeners.get(this)).tableChanged(e);
        }
    }
}

