/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.histogram;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.rmi.RemoteException;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.Swingable;
import nl.tudelft.simulation.jstats.charts.histogram.HistogramDataset;
import nl.tudelft.simulation.jstats.charts.histogram.HistogramDomainAxis;
import nl.tudelft.simulation.jstats.charts.histogram.HistogramSeries;
import nl.tudelft.simulation.jstats.statistics.Counter;
import nl.tudelft.simulation.logger.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;

public class Histogram
implements Swingable {
    public static final String LABEL_X_AXIS = "X";
    public static final String LABEL_Y_AXIS = "#";
    protected JFreeChart chart = null;
    protected HistogramDataset dataset = null;

    public Histogram(String title, double[] domain, int numberofBins) {
        this(title, domain, null, numberofBins);
    }

    public Histogram(String title, double[] domain, double[] range, int numberofBins) {
        this.dataset = new HistogramDataset(domain, range, numberofBins);
        this.chart = ChartFactory.createHistogram(title, LABEL_X_AXIS, LABEL_Y_AXIS, this.dataset, PlotOrientation.VERTICAL, true, true, true);
        this.chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        this.chart.getXYPlot().setRangeAxis(new NumberAxis(LABEL_Y_AXIS));
        this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        this.chart.getXYPlot().setDomainAxis(new HistogramDomainAxis(this.chart.getXYPlot(), LABEL_X_AXIS, domain, numberofBins));
        this.dataset.addChangeListener(this.chart.getXYPlot());
    }

    public synchronized void add(Counter counter) {
        HistogramSeries set = this.getDataset().addSeries(counter.getDescription());
        counter.addListener(set, Counter.COUNT_EVENT, false);
    }

    public synchronized void add(String description, EventProducerInterface source, EventType eventType) {
        HistogramSeries set = this.getDataset().addSeries(description);
        try {
            source.addListener((EventListenerInterface)set, eventType, false);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"add", (Throwable)exception);
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public Container getSwingPanel() {
        ChartPanel result = new ChartPanel(this.chart);
        result.setMouseZoomable(true, false);
        return result;
    }

    public HistogramDataset getDataset() {
        return this.dataset;
    }
}

