/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.xy;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.rmi.RemoteException;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.Swingable;
import nl.tudelft.simulation.jstats.charts.xy.XYDataset;
import nl.tudelft.simulation.jstats.charts.xy.XYSeries;
import nl.tudelft.simulation.jstats.statistics.Persistent;
import nl.tudelft.simulation.language.filters.Filterinterface;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.plot.PlotOrientation;

public class XYChart
implements Swingable {
    public static final short XLINEAR_YLINEAR = 0;
    public static final short XLINEAR_YLOGARITHMIC = 1;
    public static final short XLOGARITHMIC_YLINEAR = 2;
    public static final short XLOGARITHMIC_YLOGARITHMIC = 3;
    public static final String LABEL_X_AXIS = "X";
    public static final String LABEL_Y_AXIS = "value";
    protected JFreeChart chart = null;
    protected XYDataset dataset = new XYDataset();
    protected short axisType = 0;
    private double period = Double.POSITIVE_INFINITY;

    public XYChart(String title) {
        this(title, null, null);
    }

    public XYChart(String title, short axisType) {
        this(title, null, null, axisType);
    }

    public XYChart(String title, double[] domain) {
        this(title, domain, null);
    }

    public XYChart(String title, double period) {
        this(title, period, null);
    }

    public XYChart(String title, double period, short axisType) {
        this(title, period, null, axisType);
    }

    public XYChart(String title, double[] domain, short axisType) {
        this(title, domain, null, axisType);
    }

    public XYChart(String title, double[] domain, double[] range) {
        this(title, domain, range, 0);
    }

    public XYChart(String title, double period, double[] range) {
        this(title, period, range, 0);
    }

    public XYChart(String title, double period, double[] range, short axisType) {
        this(title, new double[]{Double.NaN, period}, range, axisType);
    }

    public XYChart(String title, double[] domain, double[] range, short axisType) {
        this.chart = ChartFactory.createXYLineChart(title, LABEL_X_AXIS, LABEL_Y_AXIS, this.dataset, PlotOrientation.VERTICAL, true, true, true);
        this.chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        this.axisType = axisType;
        switch (this.axisType) {
            case 1: {
                this.chart.getXYPlot().setRangeAxis(new LogarithmicAxis(LABEL_Y_AXIS));
                break;
            }
            case 2: {
                this.chart.getXYPlot().setDomainAxis(new LogarithmicAxis(LABEL_X_AXIS));
                break;
            }
            case 3: {
                this.chart.getXYPlot().setDomainAxis(new LogarithmicAxis(LABEL_X_AXIS));
                this.chart.getXYPlot().setRangeAxis(new LogarithmicAxis(LABEL_Y_AXIS));
                break;
            }
        }
        if (domain != null) {
            if (Double.isNaN(domain[0])) {
                this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
                this.period = domain[1];
            } else {
                this.chart.getXYPlot().getDomainAxis().setAutoRange(false);
                this.chart.getXYPlot().getDomainAxis().setLowerBound(domain[0]);
                this.chart.getXYPlot().getDomainAxis().setUpperBound(domain[1]);
            }
        } else {
            this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
        }
        if (range != null) {
            this.chart.getXYPlot().getRangeAxis().setAutoRange(false);
            this.chart.getXYPlot().getRangeAxis().setLowerBound(range[0]);
            this.chart.getXYPlot().getRangeAxis().setUpperBound(range[1]);
        } else {
            this.chart.getXYPlot().getRangeAxis().setAutoRange(true);
        }
        this.dataset.addChangeListener(this.chart.getXYPlot());
        this.getChart().fireChartChanged();
    }

    public void add(Persistent persistent) {
        XYSeries set = new XYSeries(persistent.getDescription(), this.axisType, this.period);
        persistent.addListener(set, Persistent.VALUE_EVENT, false);
        this.getDataset().addSeries(set);
    }

    public void add(String description, EventProducerInterface source, EventType eventType) throws RemoteException {
        XYSeries set = new XYSeries(description, this.axisType, this.period);
        source.addListener((EventListenerInterface)set, eventType, (short)0, false);
        this.getDataset().addSeries(set);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public Container getSwingPanel() {
        ChartPanel result = new ChartPanel(this.chart);
        result.setMouseZoomable(true, false);
        return result;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setFilter(Filterinterface filter) {
        this.dataset.setFilter(filter);
    }
}

