/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.xy;

import java.util.ArrayList;
import java.util.Arrays;
import nl.tudelft.simulation.jstats.charts.xy.XYSeries;
import nl.tudelft.simulation.language.filters.Filterinterface;
import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;

public class XYDataset
extends AbstractDataset
implements org.jfree.data.XYDataset,
DatasetChangeListener {
    private XYSeries[] series = new XYSeries[0];

    public XYDataset() {
        this.fireDatasetChanged();
    }

    public void datasetChanged(DatasetChangeEvent arg0) {
        if (arg0 != null) {
            this.fireDatasetChanged();
        }
    }

    public synchronized void addSeries(XYSeries dataset) {
        dataset.addChangeListener(this);
        ArrayList<XYSeries> list = new ArrayList<XYSeries>(Arrays.asList(this.series));
        list.add(dataset);
        this.series = list.toArray(new XYSeries[list.size()]);
        this.fireDatasetChanged();
    }

    public int getItemCount(int serie) {
        return this.series[serie].getItemCount();
    }

    public Number getXValue(int serie, int item) {
        return this.series[serie].getXValue(item);
    }

    public Number getYValue(int serie, int item) {
        return this.series[serie].getYValue(item);
    }

    public int getSeriesCount() {
        return this.series.length;
    }

    public String getSeriesName(int serie) {
        return this.series[serie].getSeriesName();
    }

    public double getX(int serie, int item) {
        return this.series[serie].getXValue(item).doubleValue();
    }

    public double getY(int serie, int item) {
        return this.series[serie].getYValue(item).doubleValue();
    }

    public void setFilter(Filterinterface filter) {
        for (int i = 0; i < this.series.length; ++i) {
            this.series[i].setFilter(filter);
        }
    }
}

